const hre = require("hardhat");

async function main() {
    const [deployer] = await hre.ethers.getSigners();
    console.log(`🚀 Déploiement en cours avec l'adresse : ${deployer.address}`);

    const CryptoClickerToken = await hre.ethers.getContractFactory("CryptoClickerToken");
    const token = await CryptoClickerToken.deploy(deployer.address);

    await token.waitForDeployment();
    console.log(`✅ Déployé sur l'adresse : ${await token.getAddress()}`);
}

main().catch((error) => {
    console.error("❌ Erreur de déploiement :", error);
    process.exit(1);
});
