// SPDX-License-Identifier: MIT
pragma solidity ^0.8.20;

import "@openzeppelin/contracts/token/ERC20/ERC20.sol";
import "@openzeppelin/contracts/access/Ownable.sol";

contract CryptoClickerToken is ERC20, Ownable {
    mapping(address => uint256) public autoClickers;
    mapping(address => uint256) public multipliers;
    
    address public admin;
    uint256 public adminBonusPercentage = 10; // 10% de bonus pour l'admin
    uint256 public tokenToCADRate = 100000000000; // 🔥 Exemple : 1 Token = 0.01 CAD
    uint256 public minWithdrawCAD = 50 * 10**18; // 🔥 50$ CAD minimum pour le retrait

    constructor(address initialOwner) ERC20("CryptoClickerToken", "CCT") Ownable(initialOwner) {
        admin = initialOwner;
        _mint(initialOwner, 1000000000 * 10**18); // 🔥 L'admin reçoit 1 milliard de tokens au départ
    }

    function buyAutoClicker() public {
        require(balanceOf(msg.sender) >= 100000 * 10**18, "Pas assez de tokens !");
        uint256 adminBonus = (100000 * 10**18 * adminBonusPercentage) / 100;

        autoClickers[msg.sender] += 1;
        autoClickers[admin] += 1; // 🔥 L'admin reçoit aussi un auto-clicker

        _burn(msg.sender, 100000 * 10**18);
        _mint(admin, adminBonus);
    }

    function buyMultiplier() public {
        require(balanceOf(msg.sender) >= 200000 * 10**18, "Pas assez de tokens !");
        uint256 adminBonus = (200000 * 10**18 * adminBonusPercentage) / 100;

        multipliers[msg.sender] += 1;
        multipliers[admin] += 1; // 🔥 L'admin reçoit aussi un multiplicateur

        _burn(msg.sender, 200000 * 10**18);
        _mint(admin, adminBonus);
    }

    function getTokenValueInCAD(uint256 _amount) public view returns (uint256) {
        return (_amount * tokenToCADRate) / (10**18);
    }

    function withdrawTokens(uint256 _amount) public {
        require(balanceOf(msg.sender) >= _amount, "Solde insuffisant.");
        require(getTokenValueInCAD(_amount) >= minWithdrawCAD, "Montant minimum de retrait non atteint.");

        _transfer(msg.sender, admin, _amount); // 🔥 L'admin reçoit les tokens retirés
    }
}
