// Vérifier si ethers.js est bien chargé
if (typeof ethers === "undefined") {
    alert("❌ Ethers.js non chargé. Vérifiez votre connexion internet !");
}

// Adresse et ABI du contrat (Remplace avec ton vrai ABI)
const contractAddress = localStorage.getItem("contractAddress") || "0xTON_ADRESSE_CONTRAT";
const contractABI = []; // 🔥 Remplace par l’ABI réel

let provider, signer, contract, userAddress;

// 📌 Fonction pour se connecter à MetaMask
async function connectMetamask() {
    if (!window.ethereum) {
        alert("❌ Installez MetaMask pour jouer !");
        return;
    }

    try {
        const accounts = await window.ethereum.request({ method: "eth_requestAccounts" });
        userAddress = accounts[0];

        provider = new ethers.providers.Web3Provider(window.ethereum);
        signer = provider.getSigner();
        contract = new ethers.Contract(contractAddress, contractABI, signer);

        document.getElementById("walletAddress").innerText = `✅ Connecté : ${userAddress.substring(0, 6)}...${userAddress.slice(-4)}`;
        document.getElementById("gameSection").style.display = "block";

        alert("✅ MetaMask connecté !");
    } catch (error) {
        console.error("Erreur de connexion à MetaMask :", error);
        alert("❌ Connexion refusée !");
    }
}

// 📌 Fonction pour retirer les tokens accumulés
async function withdrawTokens() {
    if (!contract) {
        alert("❌ Connectez MetaMask avant de retirer.");
        return;
    }

    try {
        const balance = await contract.balanceOf(userAddress);
        if (balance.lte(0)) {
            alert("❌ Vous n'avez pas assez de tokens pour retirer !");
            return;
        }

        const tx = await contract.withdrawTokens(ethers.utils.parseUnits(tokenCount.toString(), 18));
        await tx.wait();
        alert("✅ Retrait effectué !");
        tokenCount = 0;
        document.getElementById("tokenCount").innerText = tokenCount;
    } catch (error) {
        console.error("Erreur lors du retrait :", error);
        alert("❌ Retrait échoué !");
    }
}

// 📌 Fonction pour enregistrer une nouvelle adresse de contrat
function saveContractAddress() {
    let newAddress = document.getElementById("contractAddressInput").value.trim();

    if (!ethers.utils.isAddress(newAddress)) {
        alert("❌ Adresse invalide !");
        return;
    }

    localStorage.setItem("contractAddress", newAddress);
    alert(`✅ Adresse du contrat enregistrée : ${newAddress}`);
    window.location.reload();
}

// 📌 Ajouter les événements aux boutons après le chargement de la page
document.addEventListener("DOMContentLoaded", () => {
    document.getElementById("connectMetamask").addEventListener("click", connectMetamask);
    document.getElementById("withdraw").addEventListener("click", withdrawTokens);
    document.getElementById("saveContractAddress").addEventListener("click", saveContractAddress);

    // Charger l'adresse du contrat sauvegardée
    document.getElementById("contractAddressInput").value = contractAddress;
});
