import "hardhat/types/config";
import "hardhat/types/runtime";
import { DeployConfig, StrategyConfig } from "@nomicfoundation/ignition-core";
declare module "hardhat/types/config" {
    interface ProjectPathsUserConfig {
        ignition?: string;
    }
    interface ProjectPathsConfig {
        ignition: string;
    }
    interface HardhatNetworkUserConfig {
        ignition?: {
            maxFeePerGasLimit?: bigint;
            maxPriorityFeePerGas?: bigint;
            gasPrice?: bigint;
            disableFeeBumping?: boolean;
            explorerUrl?: string;
        };
    }
    interface HardhatNetworkConfig {
        ignition: {
            maxFeePerGasLimit?: bigint;
            maxPriorityFeePerGas?: bigint;
            gasPrice?: bigint;
            disableFeeBumping?: boolean;
            explorerUrl?: string;
        };
    }
    interface HttpNetworkUserConfig {
        ignition?: {
            maxFeePerGasLimit?: bigint;
            maxPriorityFeePerGas?: bigint;
            gasPrice?: bigint;
            disableFeeBumping?: boolean;
            explorerUrl?: string;
        };
    }
    interface HttpNetworkConfig {
        ignition: {
            maxFeePerGasLimit?: bigint;
            maxPriorityFeePerGas?: bigint;
            gasPrice?: bigint;
            disableFeeBumping?: boolean;
            explorerUrl?: string;
        };
    }
    interface HardhatUserConfig {
        ignition?: Partial<DeployConfig> & {
            strategyConfig?: Partial<StrategyConfig>;
        };
    }
    interface HardhatConfig {
        ignition: Partial<DeployConfig> & {
            strategyConfig?: Partial<StrategyConfig>;
        };
    }
}
//# sourceMappingURL=type-extensions.d.ts.map