import { BatchInitializeEvent, BeginNextBatchEvent, CallExecutionStateCompleteEvent, CallExecutionStateInitializeEvent, ContractAtExecutionStateInitializeEvent, DeploymentCompleteEvent, DeploymentExecutionStateCompleteEvent, DeploymentExecutionStateInitializeEvent, DeploymentInitializeEvent, DeploymentParameters, DeploymentStartEvent, EncodeFunctionCallExecutionStateInitializeEvent, ExecutionEventListener, NetworkInteractionRequestEvent, OnchainInteractionBumpFeesEvent, OnchainInteractionDroppedEvent, OnchainInteractionReplacedByUserEvent, OnchainInteractionTimeoutEvent, ReadEventArgExecutionStateInitializeEvent, ReconciliationWarningsEvent, RunStartEvent, SendDataExecutionStateCompleteEvent, SendDataExecutionStateInitializeEvent, SetModuleIdEvent, SetStrategyEvent, StaticCallCompleteEvent, StaticCallExecutionStateCompleteEvent, StaticCallExecutionStateInitializeEvent, TransactionConfirmEvent, TransactionSendEvent, WipeApplyEvent } from "@nomicfoundation/ignition-core";
import { UiState } from "./types";
export declare class PrettyEventHandler implements ExecutionEventListener {
    private _deploymentParams;
    private _disableOutput;
    private _uiState;
    constructor(_deploymentParams?: DeploymentParameters, _disableOutput?: boolean);
    get state(): UiState;
    set state(uiState: UiState);
    deploymentStart(event: DeploymentStartEvent): void;
    deploymentInitialize(event: DeploymentInitializeEvent): void;
    runStart(_event: RunStartEvent): void;
    beginNextBatch(_event: BeginNextBatchEvent): void;
    wipeApply(event: WipeApplyEvent): void;
    deploymentExecutionStateInitialize(event: DeploymentExecutionStateInitializeEvent): void;
    deploymentExecutionStateComplete(event: DeploymentExecutionStateCompleteEvent): void;
    callExecutionStateInitialize(event: CallExecutionStateInitializeEvent): void;
    callExecutionStateComplete(event: CallExecutionStateCompleteEvent): void;
    staticCallExecutionStateInitialize(event: StaticCallExecutionStateInitializeEvent): void;
    staticCallExecutionStateComplete(event: StaticCallExecutionStateCompleteEvent): void;
    sendDataExecutionStateInitialize(event: SendDataExecutionStateInitializeEvent): void;
    sendDataExecutionStateComplete(event: SendDataExecutionStateCompleteEvent): void;
    contractAtExecutionStateInitialize(event: ContractAtExecutionStateInitializeEvent): void;
    readEventArgumentExecutionStateInitialize(event: ReadEventArgExecutionStateInitializeEvent): void;
    encodeFunctionCallExecutionStateInitialize(event: EncodeFunctionCallExecutionStateInitializeEvent): void;
    batchInitialize(event: BatchInitializeEvent): void;
    networkInteractionRequest(_event: NetworkInteractionRequestEvent): void;
    transactionSend(_event: TransactionSendEvent): void;
    transactionConfirm(_event: TransactionConfirmEvent): void;
    staticCallComplete(_event: StaticCallCompleteEvent): void;
    onchainInteractionBumpFees(event: OnchainInteractionBumpFeesEvent): void;
    onchainInteractionDropped(_event: OnchainInteractionDroppedEvent): void;
    onchainInteractionReplacedByUser(_event: OnchainInteractionReplacedByUserEvent): void;
    onchainInteractionTimeout(_event: OnchainInteractionTimeoutEvent): void;
    deploymentComplete(event: DeploymentCompleteEvent): void;
    reconciliationWarnings(event: ReconciliationWarningsEvent): void;
    setModuleId(event: SetModuleIdEvent): void;
    setStrategy(event: SetStrategyEvent): void;
    ledgerConnectionStart(): void;
    ledgerConnectionSuccess(): void;
    ledgerConnectionFailure(): void;
    ledgerConfirmationStart(): void;
    ledgerConfirmationSuccess(): void;
    ledgerConfirmationFailure(): void;
    private _setFutureStatusInitializedAndRedisplayBatch;
    private _setFutureStatusCompleteAndRedisplayBatch;
    private _setFutureStatusAndRedisplayBatch;
    private _applyUpdateToBatchFuture;
    private _getFutureStatusFromEventResult;
    private _applyResultToBatches;
    private _hasUpdatedResult;
    private _redisplayCurrentBatch;
    private _clearCurrentLine;
    private _clearUpToHeight;
}
//# sourceMappingURL=pretty-event-handler.d.ts.map