<?php
session_start();

// Vérifier si l'utilisateur est connecté
if (!isset($_SESSION['user_id'])) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Non autorisé']);
    exit();
}

// Vérifier si la requête est de type POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Méthode non autorisée']);
    exit();
}

// Vérifier le jeton CSRF
if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Jeton CSRF invalide']);
    exit();
}

// Inclure les fichiers nécessaires
include_once "config/database.php";
include_once "models/Message.php";

// Récupérer les données
$sender_id = $_SESSION['user_id'];
$receiver_id = isset($_POST['receiver_id']) ? $_POST['receiver_id'] : null;
$file_type = isset($_POST['type']) ? $_POST['type'] : 'file';

// Vérifier si les données sont valides
if (!$receiver_id || !isset($_FILES['file'])) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Données manquantes']);
    exit();
}

// Nettoyer les données
$receiver_id = filter_var($receiver_id, FILTER_SANITIZE_NUMBER_INT);

// Vérifier le fichier
$file = $_FILES['file'];
$allowed_types = [
    'image' => ['image/jpeg', 'image/png', 'image/gif'],
    'file' => ['application/pdf', 'application/msword', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', 'text/plain']
];

// Vérifier le type de fichier
if (!in_array($file['type'], $allowed_types[$file_type])) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Type de fichier non autorisé']);
    exit();
}

// Vérifier la taille du fichier (max 5MB)
if ($file['size'] > 5 * 1024 * 1024) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Le fichier est trop volumineux (max 5MB)']);
    exit();
}

// Créer le répertoire d'upload si nécessaire
$upload_dir = 'uploads/' . $file_type . 's/';
if (!file_exists($upload_dir)) {
    mkdir($upload_dir, 0777, true);
}

// Générer un nom de fichier unique
$file_extension = pathinfo($file['name'], PATHINFO_EXTENSION);
$file_name = uniqid() . '.' . $file_extension;
$target_file = $upload_dir . $file_name;

// Déplacer le fichier
if (move_uploaded_file($file['tmp_name'], $target_file)) {
    // Instancier la base de données
    $database = new Database();
    $db = $database->getConnection();
    
    // Instancier l'objet Message
    $message = new Message($db);
    
    // Créer un message avec le lien vers le fichier
    $message->sender_id = $ $message->sender_id = $sender_id;
    $message->receiver_id = $receiver_id;
    
    if ($file_type === 'image') {
        $message->message = '<img src="' . $target_file . '" alt="Image" class="message-image">';
    } else {
        $message->message = '<a href="' . $target_file . '" target="_blank" class="message-file"><i class="fas fa-file"></i> ' . htmlspecialchars($file['name']) . '</a>';
    }
    
    if ($message->create()) {
        header('Content-Type: application/json');
        echo json_encode(['success' => true, 'file_url' => $target_file]);
    } else {
        // Supprimer le fichier en cas d'erreur
        unlink($target_file);
        header('Content-Type: application/json');
        echo json_encode(['success' => false, 'message' => 'Erreur lors de l\'enregistrement du message']);
    }
} else {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Erreur lors du téléchargement du fichier']);
}
?>