$(document).ready(function() {
    // Fonction pour gérer la navigation mobile
    function handleMobileNavigation() {
        // Gérer les clics sur les liens de la sidebar
        $('.sidebar a').click(function(e) {
            var href = $(this).attr('href');
            
            // Si c'est un lien vers une conversation
            if (href.includes('contact_id')) {
                e.preventDefault();
                $('.sidebar').addClass('hidden');
                $('.chat-area').addClass('active');
                
                // Mettre à jour l'URL sans recharger la page
                history.pushState(null, null, href);
                
                // Charger la conversation via AJAX
                loadConversation(href);
            }
            // Si c'est un lien vers une autre page (profil, paramètres, etc.)
            else {
                e.preventDefault();
                $('.sidebar').addClass('hidden');
                
                // Charger la page dans un conteneur
                var pageContainer = $('<div class="page-container"></div>');
                $('body').append(pageContainer);
                
                // Ajouter une classe active après un court délai pour l'animation
                setTimeout(() => {
                    pageContainer.addClass('active');
                }, 50);
                
                // Charger le contenu de la page
                $.get(href, function(response) {
                    pageContainer.html(response);
                    
                    // Ajouter le bouton retour
                    var header = pageContainer.find('.profile-header, .settings-header');
                    if (header.length) {
                        header.prepend(`
                            <a href="#" class="back-button">
                                <i class="fas fa-arrow-left"></i>
                                <span>Retour</span>
                            </a>
                        `);
                    }
                });
            }
        });
        
        // Gérer le bouton retour
        $(document).on('click', '.back-button', function(e) {
            e.preventDefault();
            
            // Si on est dans une conversation
            if ($('.chat-area.active').length) {
                $('.chat-area').removeClass('active');
                $('.sidebar').removeClass('hidden');
            }
            // Si on est dans une autre page
            else {
                var pageContainer = $(this).closest('.page-container');
                pageContainer.removeClass('active');
                $('.sidebar').removeClass('hidden');
                
                // Supprimer le conteneur après l'animation
                setTimeout(() => {
                    pageContainer.remove();
                }, 300);
            }
        });
    }
    
    // Fonction pour charger une conversation
    function loadConversation(url) {
        $.get(url, function(response) {
            // Extraire et mettre à jour le contenu de la conversation
            var newChatArea = $(response).find('.chat-area').html();
            $('.chat-area').html(newChatArea);
            
            // Réinitialiser les écouteurs d'événements
            initializeMessageHandlers();
            scrollToBottom();
        });
    }
    
    // Initialiser la navigation mobile
    if (window.innerWidth <= 768) {
        handleMobileNavigation();
    }
    
    // Réagir aux changements de taille d'écran
    $(window).resize(function() {
        if (window.innerWidth <= 768) {
            handleMobileNavigation();
        }
    });
    
    // ... reste du code JavaScript existant ...
});