<?php
session_start();

// Vérifier si l'utilisateur est connecté
if (!isset($_SESSION['user_id'])) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Non autorisé']);
    exit();
}

// Vérifier si la requête est de type POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Méthode non autorisée']);
    exit();
}

// Vérifier le jeton CSRF
if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Jeton CSRF invalide']);
    exit();
}

// Inclure les fichiers nécessaires
include_once "config/database.php";
include_once "models/Message.php";

// Récupérer l'ID du message
$user_id = $_SESSION['user_id'];
$message_id = isset($_POST['message_id']) ? $_POST['message_id'] : null;

// Vérifier si l'ID du message est valide
if (!$message_id) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'ID de message manquant']);
    exit();
}

// Nettoyer les données
$message_id = filter_var($message_id, FILTER_SANITIZE_NUMBER_INT);

// Instancier la base de données
$database = new Database();
$db = $database->getConnection();

// Instancier l'objet Message
$message = new Message($db);

// Supprimer le message
if ($message->deleteMessage($message_id, $user_id)) {
    header('Content-Type: application/json');
    echo json_encode(['success' => true]);
} else {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Vous n\'êtes pas autorisé à supprimer ce message']);
}
?>