<?php
// Vérifier si l'utilisateur est connecté directement
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}

// Vérifier si l'utilisateur est administrateur (à implémenter)
$is_admin = true; // Simuler un utilisateur administrateur

// Traitement du formulaire d'administration
if (isset($_POST['update_admin'])) {
    // Mise à jour des paramètres d'administration
    $user_management = isset($_POST['user_management']) ? 1 : 0;
    $content_moderation = isset($_POST['content_moderation']) ? 1 : 0;
    $system_logs = isset($_POST['system_logs']) ? 1 : 0;
    
    // Mettre à jour les paramètres d'administration (à implémenter dans la classe User)
    // Pour l'instant, nous simulons une mise à jour réussie
    $success_message = "Vos paramètres d'administration ont été mis à jour avec succès.";
    $active_tab = 'admin';
}
?>

<div class="tab-pane <?php echo $active_tab === 'admin' ? 'active' : ''; ?>" id="admin">
    <?php if ($is_admin): ?>
        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post" class="settings-form">
            <h3>Paramètres d'administration</h3>
            
            <div class="form-group">
                <label class="checkbox-label">
                    <input type="checkbox" name="user_management" <?php echo ($admin_preferences['user_management'] == 1) ? 'checked' : ''; ?>>
                    Gestion des utilisateurs
                </label>
                <p class="form-text">Activer la gestion des utilisateurs (création, modification, suppression)</p>
            </div>
            
            <div class="form-group">
                <label class="checkbox-label">
                    <input type="checkbox" name="content_moderation" <?php echo ($admin_preferences['content_moderation'] == 1) ? 'checked' : ''; ?>>
                    Modération du contenu
                </label>
                <p class="form-text">Activer la modération du contenu des messages</p>
            </div>
            
            <div class="form-group">
                <label class="checkbox-label">
                    <input type="checkbox" name="system_logs" <?php echo ($admin_preferences['system_logs'] == 1) ? 'checked' : ''; ?>>
                    Journaux système
                </label>
                <p class="form-text">Activer l'enregistrement des journaux système</p>
            </div>
            
            <div class="admin-dashboard">
                <h4>Tableau de bord d'administration</h4>
                
                <div class="admin-stats">
                    <div class="admin-stat-card">
                        <div class="stat-icon"><i class="fas fa-users"></i></div>
                        <div class="stat-info">
                            <div class="stat-value">152</div>
                            <div class="stat-label">Utilisateurs</div>
                        </div>
                    </div>
                    
                    <div class="admin-stat-card">
                        <div class="stat-icon"><i class="fas fa-comment"></i></div>
                        <div class="stat-info">
                            <div class="stat-value">8,547</div>
                            <div class="stat-label">Messages</div>
                        </div>
                    </div>
                    
                    <div class="admin-stat-card">
                        <div class="stat-icon"><i class="fas fa-server"></i></div>
                        <div class="stat-info">
                            <div class="stat-value">98.7%</div>
                            <div class="stat-label">Disponibilité</div>
                        </div>
                    </div>
                </div>
                
                <div class="admin-actions">
                    <a href="#" class="admin-action-btn">
                        <i class="fas fa-user-plus"></i>
                        <span>Ajouter un utilisateur</span>
                    </a>
                    <a href="#" class="admin-action-btn">
                        <i class="fas fa-shield-alt"></i>
                        <span>Modération</span>
                    </a>
                    <a href="#" class="admin-action-btn">
                        <i class="fas fa-file-alt"></i>
                        <span>Journaux</span>
                    </a>
                    <a href="#" class="admin-action-btn">
                        <i class="fas fa-cog"></i>
                        <span>Configuration</span>
                    </a>
                </div>
            </div>
            
            <div class="admin-recent-activity">
                <h4>Activité récente</h4>
                
                <div class="activity-list">
                    <div class="activity-item">
                        <div class="activity-icon"><i class="fas fa-user-plus"></i></div>
                        <div class="activity-details">
                            <div class="activity-text">Nouvel utilisateur inscrit: <strong>Marie Dupont</strong></div>
                            <div class="activity-time">Il y a 2 heures</div>
                        </div>
                    </div>
                    
                    <div class="activity-item">
                        <div class="activity-icon"><i class="fas fa-exclamation-triangle"></i></div>
                        <div class="activity-details">
                            <div class="activity-text">Contenu signalé par <strong>Jean Martin</strong></div>
                            <div class="activity-time">Il y a 5 heures</div>
                        </div>
                    </div>
                    
                    <div class="activity-item">
                        <div class="activity-icon"><i class="fas fa-user-edit"></i></div>
                        <div class="activity-details">
                            <div class="activity-text">Profil mis à jour: <strong>Pierre Durand</strong></div>
                            <div class="activity-time">Il y a 1 jour</div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="form-group" style="margin-top: 20px;">
                <button type="submit" name="update_admin" class="btn btn-primary">
                    <i class="fas fa-save"></i> Enregistrer les modifications
                </button>
            </div>
        </form>
    <?php else: ?>
        <div class="access-denied">
            <div class="access-denied-icon">
                <i class="fas fa-lock"></i>
            </div>
            <h3>Accès refusé</h3>
            <p>Vous n'avez pas les autorisations nécessaires pour accéder à cette section.</p>
            <p>Veuillez contacter un administrateur si vous pensez que vous devriez avoir accès.</p>
        </div>
    <?php endif; ?>
</div>