<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

class Mailer {
    private $mailer;
    private $config;
    
    public function __construct() {
        $this->config = require_once __DIR__ . '/../config/mail.php';
        $this->mailer = new PHPMailer(true);
        
        try {
            // Configuration du serveur SMTP
            $this->mailer->isSMTP();
            $this->mailer->Host = $this->config['host'];
            $this->mailer->SMTPAuth = true;
            $this->mailer->Username = $this->config['username'];
            $this->mailer->Password = $this->config['password'];
            $this->mailer->SMTPSecure = $this->config['encryption'];
            $this->mailer->Port = $this->config['port'];
            
            // Configuration de l'expéditeur
            $this->mailer->setFrom($this->config['from_address'], $this->config['from_name']);
            
            // Configuration générale
            $this->mailer->CharSet = 'UTF-8';
            $this->mailer->isHTML(true);
            
        } catch (Exception $e) {
            error_log("Erreur d'initialisation du mailer: " . $e->getMessage());
        }
    }
    
    public function sendPasswordReset($email, $token, $username) {
        try {
            // Charger les templates
            $htmlTemplate = file_get_contents(__DIR__ . '/../templates/password_reset_email.html');
            $textTemplate = file_get_contents(__DIR__ . '/../templates/password_reset_email.txt');
            
            // Construire le lien de réinitialisation
            $resetLink = 'https://com.test.carnetsocial.com/messenger/reset_password.php?token=' . $token;
            
            // Remplacer les variables dans les templates
            $replacements = [
                '{NOM_UTILISATEUR}' => $username,
                '{LIEN_REINITIALISATION}' => $resetLink
            ];
            
            $htmlContent = str_replace(array_keys($replacements), array_values($replacements), $htmlTemplate);
            $textContent = str_replace(array_keys($replacements), array_values($replacements), $textTemplate);
            
            // Configuration du destinataire
            $this->mailer->addAddress($email, $username);
            
            // Configuration du message
            $this->mailer->Subject = 'Réinitialisation de mot de passe - Messenger Clone';
            $this->mailer->Body = $htmlContent;
            $this->mailer->AltBody = $textContent;
            
            // Envoyer l'email
            $this->mailer->send();
            return true;
            
        } catch (Exception $e) {
            error_log("Erreur lors de l'envoi de l'email: " . $e->getMessage());
            return false;
        }
    }
}
?>