<?php
session_start();

// Vérifier si l'utilisateur est connecté
if (!isset($_SESSION['user_id'])) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Non autorisé']);
    exit();
}

// Vérifier si la requête est de type GET
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Méthode non autorisée']);
    exit();
}

// Inclure les fichiers nécessaires
include_once "config/database.php";
include_once "models/Message.php";

// Récupérer l'ID du contact
$user_id = $_SESSION['user_id'];
$contact_id = isset($_GET['contact_id']) ? $_GET['contact_id'] : null;
$last_id = isset($_GET['last_id']) ? $_GET['last_id'] : 0;

// Vérifier si l'ID du contact est valide
if (!$contact_id) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'ID de contact manquant']);
    exit();
}

// Nettoyer les données
$contact_id = filter_var($contact_id, FILTER_SANITIZE_NUMBER_INT);
$last_id = filter_var($last_id, FILTER_SANITIZE_NUMBER_INT);

// Instancier la base de données
$database = new Database();
$db = $database->getConnection();

// Instancier l'objet Message
$message = new Message($db);

// Récupérer les nouveaux messages
$new_messages = $message->getNewMessages($user_id, $contact_id, $last_id);

// Marquer les messages comme lus
$message->markAsRead($contact_id, $user_id);

// Renvoyer les nouveaux messages
header('Content-Type: application/json');
echo json_encode(['success' => true, 'messages' => $new_messages]);
?>