<?php
session_start();

// Vérifier si l'utilisateur est déjà connecté
if (isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}

// Inclure les fichiers nécessaires
include_once "config/database.php";
include_once "models/User.php";

// Initialiser les variables
$email = "";
$email_err = "";
$success_message = "";

// Traitement du formulaire lors de la soumission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    
    // Valider l'email
    if (empty(trim($_POST["email"]))) {
        $email_err = "Veuillez entrer votre email.";
    } else {
        $email = trim($_POST["email"]);
    }
    
    // Vérifier les erreurs avant de continuer
    if (empty($email_err)) {
        // Instancier la base de données
        $database = new Database();
        $db = $database->getConnection();
        
        // Instancier l'objet User
        $user = new User($db);
        
        // Vérifier si l'email existe
        if ($user->emailExists($email)) {
            // Générer un token de réinitialisation
            $token = bin2hex(random_bytes(32));
            
            // Enregistrer le token dans la base de données
            if ($user->setResetToken($email, $token)) {
                // Récupérer les informations de l'utilisateur
                $user_info = $user->getUserByEmail($email);
                
                // Construire le lien de réinitialisation
                $reset_link = "https://" . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . "/reset_password.php?token=" . $token;
                
                // Préparer le contenu de l'email
                $to = $email;
                $subject = "Réinitialisation de votre mot de passe - Aurore";
                
                // Charger le template HTML
                $html_template = file_get_contents("templates/password_reset_email.html");
                $text_template = file_get_contents("templates/password_reset_email.txt");
                
                // Remplacer les variables dans les templates
                $replacements = array(
                    '{NOM_UTILISATEUR}' => $user_info['firstname'] . ' ' . $user_info['lastname'],
                    '{LIEN_REINITIALISATION}' => $reset_link
                );
                
                $html_message = str_replace(array_keys($replacements), array_values($replacements), $html_template);
                $text_message = str_replace(array_keys($replacements), array_values($replacements), $text_template);
                
                // En-têtes pour l'email HTML
                $headers = "From: Aurore <noreply@passi-technologie.com>\r\n";
                $headers .= "Reply-To: support@passi-technologie.com\r\n";
                $headers .= "MIME-Version: 1.0\r\n";
                $headers .= "Content-Type: multipart/alternative; boundary=\"boundary\"\r\n";
                
                // Corps du message avec les versions texte et HTML
                $message = "--boundary\r\n";
                $message .= "Content-Type: text/plain; charset=UTF-8\r\n";
                $message .= "Content-Transfer-Encoding: 8bit\r\n\r\n";
                $message .= $text_message . "\r\n\r\n";
                
                $message .= "--boundary\r\n";
                $message .= "Content-Type: text/html; charset=UTF-8\r\n";
                $message .= "Content-Transfer-Encoding: 8bit\r\n\r\n";
                $message .= $html_message . "\r\n\r\n";
                
                $message .= "--boundary--";
                
                // Envoyer l'email
                if (mail($to, $subject, $message, $headers)) {
                    $success_message = "Un email de réinitialisation a été envoyé à votre adresse email.";
                } else {
                    $email_err = "Une erreur s'est produite lors de l'envoi de l'email. Veuillez réessayer plus tard.";
                }
            } else {
                $email_err = "Une erreur s'est produite. Veuillez réessayer plus tard.";
            }
        } else {
            // Pour des raisons de sécurité, ne pas indiquer si l'email existe ou non
            $success_message = "Si votre email est enregistré, vous recevrez un lien de réinitialisation.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mot de passe oublié - Aurore</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet">
</head>
<body class="auth-page">
    <div class="auth-container">
        <div class="auth-form-container">
            <div class="auth-logo">
                <i class="fab fa-facebook-messenger"></i>
                <h1>Aurore</h1>
            </div>
            
            <h2>Mot de passe oublié</h2>
            <p class="auth-subtitle">Entrez votre email pour recevoir un lien de réinitialisation.</p>
            
            <?php if (!empty($success_message)): ?>
                <div class="alert alert-success"><?php echo $success_message; ?></div>
            <?php endif; ?>
            
            <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post" class="auth-form">
                <div class="form-group <?php echo (!empty($email_err)) ? 'has-error' : ''; ?>">
                    <label>Email</label>
                    <input type="email" name="email" class="form-control" value="<?php echo $email; ?>">
                    <span class="error-message"><?php echo $email_err; ?></span>
                </div>
                
                <div class="form-group">
                    <button type="submit" class="btn btn-primary btn-block">Envoyer le lien de réinitialisation</button>
                </div>
            </form>
            
            <div class="auth-footer">
                <p><a href="login.php">Retour à la connexion</a></p>
            </div>
        </div>
    </div>
</body>
</html>