<?php
session_start();

// Vérifier si l'utilisateur est déjà connecté
if (isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}

// Inclure les fichiers nécessaires
include_once "config/database.php";
include_once "models/User.php";

// Initialiser les variables
$firstname = $lastname = $email = $password = $confirm_password = "";
$firstname_err = $lastname_err = $email_err = $password_err = $confirm_password_err = "";

// Traitement du formulaire lors de la soumission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    
    // Valider le prénom
    if (empty(trim($_POST["firstname"]))) {
        $firstname_err = "Veuillez entrer votre prénom.";
    } else {
        $firstname = trim($_POST["firstname"]);
    }
    
    // Valider le nom
    if (empty(trim($_POST["lastname"]))) {
        $lastname_err = "Veuillez entrer votre nom.";
    } else {
        $lastname = trim($_POST["lastname"]);
    }
    
    // Valider l'email
    if (empty(trim($_POST["email"]))) {
        $email_err = "Veuillez entrer votre email.";
    } else {
        // Instancier la base de données
        $database = new Database();
        $db = $database->getConnection();
        
        // Instancier l'objet User
        $user = new User($db);
        
        // Vérifier si l'email existe déjà
        if ($user->emailExists(trim($_POST["email"]))) {
            $email_err = "Cet email est déjà utilisé.";
        } else {
            $email = trim($_POST["email"]);
        }
    }
    
    // Valider le mot de passe
    if (empty(trim($_POST["password"]))) {
        $password_err = "Veuillez entrer un mot de passe.";
    } elseif (strlen(trim($_POST["password"])) < 6) {
        $password_err = "Le mot de passe doit contenir au moins 6 caractères.";
    } else {
        $password = trim($_POST["password"]);
    }
    
    // Valider la confirmation du mot de passe
    if (empty(trim($_POST["confirm_password"]))) {
        $confirm_password_err = "Veuillez confirmer le mot de passe.";
    } else {
        $confirm_password = trim($_POST["confirm_password"]);
        if (empty($password_err) && ($password != $confirm_password)) {
            $confirm_password_err = "Les mots de passe ne correspondent pas.";
        }
    }
    
    // Vérifier les erreurs avant d'insérer dans la base de données
    if (empty($firstname_err) && empty($lastname_err) && empty($email_err) && empty($password_err) && empty($confirm_password_err)) {
        
        // Instancier la base de données si ce n'est pas déjà fait
        if (!isset($db)) {
            $database = new Database();
            $db = $database->getConnection();
            $user = new User($db);
        }
        
        // Définir les valeurs des propriétés de l'utilisateur
        $user->firstname = $firstname;
        $user->lastname = $lastname;
        $user->email = $email;
        $user->password = password_hash($password, PASSWORD_DEFAULT); // Hachage du mot de passe
        
        // Créer l'utilisateur
        if ($user->create()) {
            // Rediriger vers la page de connexion
            header("location: login.php");
        } else {
            echo "Une erreur s'est produite. Veuillez réessayer plus tard.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Inscription - Aurore</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet">
</head>
<body class="auth-page">
    <div class="auth-container">
        <div class="auth-form-container">
            <div class="auth-logo">
                <i class="fab fa-facebook-messenger"></i>
                <h1>Aurore</h1>
            </div>
            
            <h2>Créer un compte</h2>
            
            <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post" class="auth-form">
                <div class="form-row">
                    <div class="form-group <?php echo (!empty($firstname_err)) ? 'has-error' : ''; ?>">
                        <label>Prénom</label>
                        <input type="text" name="firstname" class="form-control" value="<?php echo $firstname; ?>">
                        <span class="error-message"><?php echo $firstname_err; ?></span>
                    </div>
                    
                    <div class="form-group <?php echo (!empty($lastname_err)) ? 'has-error' : ''; ?>">
                        <label>Nom</label>
                        <input type="text" name="lastname" class="form-control" value="<?php echo $lastname; ?>">
                        <span class="error-message"><?php echo $lastname_err; ?></span>
                    </div>
                </div>
                
                <div class="form-group <?php echo (!empty($email_err)) ? 'has-error' : ''; ?>">
                    <label>Email</label>
                    <input type="email" name="email" class="form-control" value="<?php echo $email; ?>">
                    <span class="error-message"><?php echo $email_err; ?></span>
                </div>
                
                <div class="form-group <?php echo (!empty($password_err)) ? 'has-error' : ''; ?>">
                    <label>Mot de passe</label>
                    <input type="password" name="password" class="form-control" value="<?php echo $password; ?>">
                    <span class="error-message"><?php echo $password_err; ?></span>
                </div>
                
                <div class="form-group <?php echo (!empty($confirm_password_err)) ? 'has-error' : ''; ?>">
                    <label>Confirmer le mot de passe</label>
                    <input type="password" name="confirm_password" class="form-control" value="<?php echo $confirm_password; ?>">
                    <span class="error-message"><?php echo $confirm_password_err; ?></span>
                </div>
                
                <div class="form-group">
                    <button type="submit" class="btn btn-success btn-block">S'inscrire</button>
                </div>
            </form>
            
            <div class="auth-footer">
                <p>Vous avez déjà un compte ? <a href="login.php">Se connecter</a></p>
            </div>
        </div>
    </div>
</body>
</html>