<?php
session_start();

// Vérifier si l'utilisateur est connecté
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// Inclure les fichiers nécessaires
include_once "config/database.php";
include_once "models/User.php";

// Instancier la base de données
$database = new Database();
$db = $database->getConnection();

// Instancier l'objet User
$user = new User($db);
$user->id = $_SESSION['user_id'];
$user->readOne();

// Initialiser les variables
$success_message = "";
$error_message = "";

// Traitement du formulaire lors de la soumission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    
    // Vérifier quelle action a été demandée
    if (isset($_POST['update_general'])) {
        // Mise à jour des paramètres généraux
        $theme = isset($_POST['theme']) ? $_POST['theme'] : 'light';
        $notifications = isset($_POST['notifications']) ? 1 : 0;
        $sounds = isset($_POST['sounds']) ? 1 : 0;
        
        // Mettre à jour les préférences de l'utilisateur
        if ($user->updatePreferences($theme, $notifications, $sounds)) {
            $success_message = "Vos paramètres généraux ont été mis à jour avec succès.";
        } else {
            $error_message = "Une erreur s'est produite lors de la mise à jour des paramètres.";
        }
    } 
    elseif (isset($_POST['update_privacy'])) {
        // Mise à jour des paramètres de confidentialité
        $show_status = isset($_POST['show_status']) ? 1 : 0;
        $read_receipts = isset($_POST['read_receipts']) ? 1 : 0;
        $typing_indicator = isset($_POST['typing_indicator']) ? 1 : 0;
        
        // Mettre à jour les paramètres de confidentialité
        if ($user->updatePrivacySettings($show_status, $read_receipts, $typing_indicator)) {
            $success_message = "Vos paramètres de confidentialité ont été mis à jour avec succès.";
        } else {
            $error_message = "Une erreur s'est produite lors de la mise à jour des paramètres.";
        }
    }
    elseif (isset($_POST['update_security'])) {
        // Mise à jour des paramètres de sécurité
        $current_password = trim($_POST['current_password']);
        $new_password = trim($_POST['new_password']);
        $confirm_password = trim($_POST['confirm_password']);
        
        // Vérifier si les champs sont remplis
        if (empty($current_password)) {
            $error_message = "Veuillez entrer votre mot de passe actuel.";
        } elseif (empty($new_password)) {
            $error_message = "Veuillez entrer un nouveau mot de passe.";
        } elseif (strlen($new_password) < 6) {
            $error_message = "Le mot de passe doit contenir au moins 6 caractères.";
        } elseif ($new_password !== $confirm_password) {
            $error_message = "Les mots de passe ne correspondent pas.";
        } else {
            // Vérifier le mot de passe actuel
            if ($user->verifyPassword($current_password)) {
                // Mettre à jour le mot de passe
                $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
                if ($user->updatePassword($hashed_password)) {
                    $success_message = "Votre mot de passe a été mis à jour avec succès.";
                } else {
                    $error_message = "Une erreur s'est produite lors de la mise à jour du mot de passe.";
                }
            } else {
                $error_message = "Le mot de passe actuel est incorrect.";
            }
        }
    }
    
    // Recharger les informations de l'utilisateur après la mise à jour
    $user->readOne();
}

// Récupérer les préférences de l'utilisateur
$preferences = $user->getPreferences();
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Paramètres - Messenger Clone</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet">
    <meta name="robots" content="noindex, nofollow">
    <meta http-equiv="Content-Security-Policy" content="default-src 'self'; script-src 'self' https://code.jquery.com; style-src 'self' https://cdnjs.cloudflare.com; img-src 'self' data:; font-src 'self' https://cdnjs.cloudflare.com;">
</head>
<body>
    <div class="messenger-container">
        <!-- Sidebar avec la liste des contacts -->
        <div class="sidebar">
            <div class="user-profile">
                <img src="<?php echo $user->profile_image ? 'uploads/profile/' . $user->profile_image : 'assets/images/default-avatar.png'; ?>" alt="Profile">
                <div class="user-info">
                    <h3><?php echo $user->firstname . ' ' . $user->lastname; ?></h3>
                    <div class="status online">
                        <span class="status-dot"></span>
                        <span class="status-text">En ligne</span>
                    </div>
                </div>
                <div class="user-actions">
                    <a href="index.php" title="Messages"><i class="fas fa-comment"></i></a>
                    <a href="profile.php" title="Profil"><i class="fas fa-user"></i></a>
                    <a href="logout.php" title="Déconnexion"><i class="fas fa-sign-out-alt"></i></a>
                </div>
            </div>
        </div>
        
        <!-- Zone principale des paramètres -->
        <div class="settings-area">
            <div class="settings-header">
                <h2>Paramètres</h2>
                <?php if (!empty($success_message)): ?>
                    <div class="alert alert-success"><?php echo $success_message; ?></div>
                <?php endif; ?>
                <?php if (!empty($error_message)): ?>
                    <div class="alert alert-danger"><?php echo $error_message; ?></div>
                <?php endif; ?>
            </div>
            
            <div class="settings-content">
                <div class="settings-tabs">
                    <button class="tab-button active" data-tab="general">Général</button>
                    <button class="tab-button" data-tab="privacy">Confidentialité</button>
                    <button class="tab-button" data-tab="security">Sécurité</button>
                </div>
                
                <div class="settings-tab-content">
                    <!-- Onglet Général -->
                    <div class="tab-pane active" id="general">
                        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post" class="settings-form">
                            <div class="form-group">
                                <label>Thème</label>
                                <select name="theme" class="form-control">
                                    <option value="light" <?php echo ($preferences['theme'] === 'light') ? 'selected' : ''; ?>>Clair</option>
                                    <option value="dark" <?php echo ($preferences['theme'] === 'dark') ? 'selected' : ''; ?>>Sombre</option>
                                    <option value="system" <?php echo ($preferences['theme'] === 'system') ? 'selected' : ''; ?>>Système</option>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label class="checkbox-label">
                                    <input type="checkbox" name="notifications" <?php echo ($preferences['notifications'] == 1) ? 'checked' : ''; ?>>
                                    Activer les notifications
                                </label>
                            </div>
                            
                            <div class="form-group">
                                <label class="checkbox-label">
                                    <input type="checkbox" name="sounds" <?php echo ($preferences['sounds'] == 1) ? 'checked' : ''; ?>>
                                    Activer les sons
                                </label>
                            </div>
                            
                            <div class="form-group">
                                <button type="submit" name="update_general" class="btn btn-primary">Enregistrer les modifications</button>
                            </div>
                        </form>
                    </div>
                    
                    <!-- Onglet Confidentialité -->
                    <div class="tab-pane" id="privacy">
                        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post" class="settings-form">
                            <div class="form-group">
                                <label class="checkbox-label">
                                    <input type="checkbox" name="show_status" <?php echo ($preferences['show_status'] == 1) ? 'checked' : ''; ?>>
                                    Afficher mon statut en ligne
                                </label>
                            </div>
                            
                            <div class="form-group">
                                <label class="checkbox-label">
                                    <input type="checkbox" name="read_receipts" <?php echo ($preferences['read_receipts'] == 1) ? 'checked' : ''; ?>>
                                    Envoyer des confirmations de lecture
                                </label>
                            </div>
                            
                            <div class="form-group">
                                <label class="checkbox-label">
                                    <input type="checkbox" name="typing_indicator" <?php echo ($preferences['typing_indicator'] == 1) ? 'checked' : ''; ?>>
                                    Afficher l'indicateur de frappe
                                </label>
                            </div>
                            
                            <div class="form-group">
                                <button type="submit" name="update_privacy" class="btn btn-primary">Enregistrer les modifications</button>
                            </div>
                        </form>
                    </div>
                    
                    <!-- Onglet Sécurité -->
                    <div class="tab-pane" id="security">
                        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post" class="settings-form">
                            <div class="form-group">
                                <label>Mot de passe actuel</label>
                                <input type="password" name="current_password" class="form-control">
                            </div>
                            
                            <div class="form-group">
                                <label>Nouveau mot de passe</label>
                                <input type="password" name="new_password" class="form-control">
                            </div>
                            
                            <div class="form-group">
                                <label>Confirmer le nouveau mot de passe</label>
                                <input type="password" name="confirm_password" class="form-control">
                            </div>
                            
                            <div class="form-group">
                                <button type="submit" name="update_security" class="btn btn-primary">Changer le mot de passe</button>
                            </div>
                        </form>
                        
                        <div class="security-info">
                            <h3>Sécurité du compte</h3>
                            <p>Votre compte est protégé par un chiffrement de bout en bout. Tous vos messages sont chiffrés et ne peuvent être lus que par vous et vos destinataires.</p>
                            
                            <div class="security-tips">
                                <h4>Conseils de sécurité</h4>
                                <ul>
                                    <li>Utilisez un mot de passe fort et unique</li>
                                    <li>Ne partagez jamais votre mot de passe avec quelqu'un d'autre</li>
                                    <li>Déconnectez-vous lorsque vous utilisez un appareil partagé</li>
                                    <li>Vérifiez régulièrement l'activité de votre compte</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            // Gestion des onglets
            $('.tab-button').click(function() {
                var tabId = $(this).data('tab');
                
                // Activer le bouton d'onglet
                $('.tab-button').removeClass('active');
                $(this).addClass('active');
                
                // Afficher le contenu de l'onglet
                $('.tab-pane').removeClass('active');
                $('#' + tabId).addClass('active');
            });
        });
    </script>
</body>
</html>