<?php
session_start();

// Vérifier si l'utilisateur est connecté
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// Inclure les fichiers nécessaires
include_once "config/database.php";
include_once "models/User.php";
include_once "models/Message.php";

// Récupérer l'ID du contact
$contact_id = isset($_GET['id']) ? $_GET['id'] : null;

if (!$contact_id) {
    header("Location: index.php");
    exit();
}

// Instancier la base de données
$database = new Database();
$db = $database->getConnection();

// Instancier l'objet User
$user = new User($db);
$user->id = $_SESSION['user_id'];
$user->readOne();

// Récupérer les informations du contact
$contact = new User($db);
$contact->id = $contact_id;
$contact->readOne();

// Instancier l'objet Message
$message = new Message($db);

// Compter le nombre total de messages échangés
$total_messages = $message->countTotalMessages($_SESSION['user_id'], $contact_id);
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Informations de contact - Messenger Clone</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet">
    <meta name="robots" content="noindex, nofollow">
    <meta http-equiv="Content-Security-Policy" content="default-src 'self'; script-src 'self' https://code.jquery.com; style-src 'self' https://cdnjs.cloudflare.com; img-src 'self' data:; font-src 'self' https://cdnjs.cloudflare.com;">
</head>
<body>
    <div class="messenger-container">
        <!-- Sidebar avec la liste des contacts -->
        <div class="sidebar">
            <div class="user-profile">
                <img src="<?php echo $user->profile_image ? 'uploads/profile/' . $user->profile_image : 'assets/images/default-avatar.png'; ?>" alt="Profile">
                <div class="user-info">
                    <h3><?php echo $user->firstname . ' ' . $user->lastname; ?></h3>
                    <div class="status online">
                        <span class="status-dot"></span>
                        <span class="status-text">En ligne</span>
                    </div>
                </div>
                <div class="user-actions">
                    <a href="index.php" title="Messages"><i class="fas fa-comment"></i></a>
                    <a href="logout.php" title="Déconnexion"><i class="fas fa-sign-out-alt"></i></a>
                </div>
            </div>
        </div>
        
        <!-- Zone principale d'informations de contact -->
        <div class="contact-info-area">
            <div class="contact-info-header">
                <a href="index.php?contact_id=<?php echo $contact_id; ?>" class="back-button">
                    <i class="fas fa-arrow-left"></i> Retour à la conversation
                </a>
                <h2>Informations de contact</h2>
            </div>
            
            <div class="contact-info-content">
                <div class="contact-profile">
                    <img src="<?php echo $contact->profile_image ? 'uploads/profile/' . $contact->profile_image : 'assets/images/default-avatar.png'; ?>" alt="<?php echo $contact->firstname; ?>" class="contact-profile-image">
                    <h3><?php echo $contact->firstname . ' ' . $contact->lastname; ?></h3>
                    <p class="contact-status <?php echo $contact->is_online ? 'online' : 'offline'; ?>">
                        <?php echo $contact->is_online ? 'En ligne' : 'Hors ligne'; ?>
                    </p>
                </div>
                
                <div class="contact-details">
                    <div class="detail-item">
                        <i class="fas fa-envelope"></i>
                        <span><?php echo $contact->email; ?></span>
                    </div>
                    
                    <div class="detail-item">
                        <i class="fas fa-calendar-alt"></i>
                        <span>Membre depuis: <?php echo date('d/m/Y', strtotime($contact->created_at)); ?></span>
                    </div>
                    
                    <div class="detail-item">
                        <i class="fas fa-comment"></i>
                        <span>Messages échangés: <?php echo $total_messages; ?></span>
                    </div>
                    
                    <?php if (!$contact->is_online && $contact->last_login): ?>
                    <div class="detail-item">
                        <i class="fas fa-clock"></i>
                        <span>Dernière connexion: <?php echo date('d/m/Y H:i', strtotime($contact->last_login)); ?></span>
                    </div>
                    <?php endif; ?>
                </div>
                
                <div class="contact-actions">
                    <a href="index.php?contact_id=<?php echo $contact_id; ?>" class="btn btn-primary">
                        <i class="fas fa-comment"></i> Envoyer un message
                    </a>
                    <a href="#" class="btn btn-secondary call-button">
                        <i class="fas fa-phone"></i> Appeler
                    </a>
                    <a href="#" class="btn btn-secondary video-call-button">
                        <i class="fas fa-video"></i> Appel vidéo
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            // Fonctionnalités des boutons d'action
            $('.call-button').click(function(e) {
                e.preventDefault();
                alert('Fonctionnalité d\'appel téléphonique en cours de développement');
            });
            
            $('.video-call-button').click(function(e) {
                e.preventDefault();
                alert('Fonctionnalité d\'appel vidéo en cours de développement');
            });
        });
    </script>
</body>
</html>