<?php
session_start();

// Vérifier si l'utilisateur est connecté
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// Inclure les fichiers nécessaires
include_once "config/database.php";
include_once "models/User.php";
include_once "models/Message.php";

// Instancier la base de données
$database = new Database();
$db = $database->getConnection();

// Instancier les objets User et Message
$user = new User($db);
$message = new Message($db);

// Récupérer l'ID de l'utilisateur connecté
$user_id = $_SESSION['user_id'];

// Récupérer les informations de l'utilisateur
$user->id = $user_id;
$user->readOne();

// Récupérer la liste des contacts
$contacts = $user->getContacts();

// Récupérer l'ID du contact sélectionné (si disponible)
$contact_id = isset($_GET['contact_id']) ? $_GET['contact_id'] : null;

// Générer un jeton CSRF pour la sécurité
if (!isset($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
$csrf_token = $_SESSION['csrf_token'];
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Aurore - Messagerie</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet">
    <meta name="robots" content="noindex, nofollow">
    <meta http-equiv="Content-Security-Policy" content="default-src 'self'; script-src 'self' https://code.jquery.com; style-src 'self' https://cdnjs.cloudflare.com; img-src 'self' data:; font-src 'self' https://cdnjs.cloudflare.com;">
</head>
<body>
    <div class="messenger-container">
        <!-- Sidebar avec la liste des contacts -->
        <div class="sidebar">
            <div class="user-profile">
                <img src="<?php echo $user->profile_image ? 'uploads/profile/' . $user->profile_image : 'assets/images/default-avatar.png'; ?>" alt="Profile">
                <div class="user-info">
                    <h3><?php echo $user->firstname . ' ' . $user->lastname; ?></h3>
                    <div class="status online">
                        <span class="status-dot"></span>
                        <span class="status-text">En ligne</span>
                    </div>
                </div>
                <div class="user-actions">
                    <a href="settings.php" title="Paramètres" class="tooltip" data-tooltip="Paramètres"><i class="fas fa-cog"></i></a>
                    <a href="profile.php" title="Profil" class="tooltip" data-tooltip="Profil"><i class="fas fa-user"></i></a>
                    <a href="logout.php" title="Déconnexion" class="tooltip" data-tooltip="Déconnexion"><i class="fas fa-sign-out-alt"></i></a>
                </div>
            </div>
            
            <div class="search-box">
                <i class="fas fa-search"></i>
                <input type="text" placeholder="Rechercher..." id="search-contact">
            </div>
            
            <div class="contacts-list">
                <?php if (empty($contacts)): ?>
                    <div class="empty-contacts">
                        <p>Aucun contact disponible</p>
                    </div>
                <?php else: ?>
                    <?php foreach ($contacts as $contact): ?>
                        <?php 
                        $active_class = ($contact_id == $contact['id']) ? 'active' : '';
                        $unread_count = $message->getUnreadCount($user_id, $contact['id']);
                        ?>
                        <a href="index.php?contact_id=<?php echo $contact['id']; ?>" class="contact-item <?php echo $active_class; ?>">
                            <div class="contact-avatar">
                                <img src="<?php echo $contact['profile_image'] ? 'uploads/profile/' . $contact['profile_image'] : 'assets/images/default-avatar.png'; ?>" alt="<?php echo $contact['firstname']; ?>">
                                <?php if ($contact['is_online']): ?>
                                    <span class="status-indicator online"></span>
                                <?php else: ?>
                                    <span class="status-indicator offline"></span>
                                <?php endif; ?>
                            </div>
                            <div class="contact-info">
                                <h4><?php echo $contact['firstname'] . ' ' . $contact['lastname']; ?></h4>
                                <p class="last-message"><?php echo $contact['last_message']; ?></p>
                            </div>
                            <div class="contact-meta">
                                <?php if ($contact['last_message_time']): ?>
                                    <span class="time"><?php echo $contact['last_message_time']; ?></span>
                                <?php endif; ?>
                                <?php if ($unread_count > 0): ?>
                                    <span class="unread-count"><?php echo $unread_count; ?></span>
                                <?php endif; ?>
                            </div>
                        </a>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Zone principale de chat -->
        <div class="chat-area">
            <?php if ($contact_id): ?>
                <?php 
                // Récupérer les informations du contact
                $contact_user = new User($db);
                $contact_user->id = $contact_id;
                $contact_user->readOne();
                
                // Récupérer les messages
                $messages = $message->getConversation($user_id, $contact_id);
                
                // Marquer les messages comme lus
                $message->markAsRead($contact_id, $user_id);
                ?>
                <div class="chat-header">
                    <div class="contact-info">
                        <img src="<?php echo $contact_user->profile_image ? 'uploads/profile/' . $contact_user->profile_image : 'assets/images/default-avatar.png'; ?>" alt="<?php echo $contact_user->firstname; ?>">
                        <div>
                            <h3><?php echo $contact_user->firstname . ' ' . $contact_user->lastname; ?></h3>
                            <?php if ($contact_user->is_online): ?>
                                <span class="status">En ligne</span>
                            <?php else: ?>
                                <span class="status">Dernière connexion: <?php echo $contact_user->last_login; ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="chat-actions">
                        <button title="Appel téléphonique" class="tooltip" data-tooltip="Appel téléphonique"><i class="fas fa-phone"></i></button>
                        <button title="Appel vidéo" class="tooltip" data-tooltip="Appel vidéo"><i class="fas fa-video"></i></button>
                        <button title="Informations" class="tooltip" data-tooltip="Informations"><i class="fas fa-info-circle"></i></button>
                    </div>
                </div>
                
                <div class="chat-messages" id="chat-messages">
                    <?php if (empty($messages)): ?>
                        <div class="empty-chat">
                            <p>Aucun message. Commencez la conversation !</p>
                        </div>
                    <?php else: ?>
                        <?php foreach ($messages as $msg): ?>
                            <div class="message <?php echo ($msg['sender_id'] == $user_id) ? 'sent' : 'received'; ?>" data-message-id="<?php echo $msg['id']; ?>">
                                <div class="message-content <div class="message-content">
                                    <?php echo $msg['message']; ?>
                                    <span class="message-time"><?php echo $msg['created_at']; ?></span>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
                
                <div class="chat-input">
                    <div class="input-actions">
                        <button title="Ajouter du contenu" class="tooltip" data-tooltip="Ajouter du contenu"><i class="fas fa-plus-circle"></i></button>
                        <button title="Envoyer une image" class="tooltip" data-tooltip="Envoyer une image"><i class="fas fa-image"></i></button>
                        <button title="Joindre un fichier" class="tooltip" data-tooltip="Joindre un fichier"><i class="fas fa-paperclip"></i></button>
                    </div>
                    <form id="message-form" action="send_message.php" method="post">
                        <input type="hidden" name="receiver_id" value="<?php echo $contact_id; ?>">
                        <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
                        <input type="text" name="message" placeholder="Écrivez un message..." autocomplete="off">
                        <button type="submit" title="Envoyer" class="tooltip" data-tooltip="Envoyer"><i class="fas fa-paper-plane"></i></button>
                    </form>
                    <!-- Champs cachés pour l'upload de fichiers -->
                    <input type="file" id="file-upload" accept="image/*" style="display: none;">
                    <input type="file" id="attachment-upload" style="display: none;">
                </div>
            <?php else: ?>
                <div class="no-chat-selected">
                    <div class="welcome-message">
                        <i class="fas fa-comments"></i>
                        <h2>Bienvenue sur Aurore</h2>
                        <p>Sélectionnez un contact pour commencer à discuter</p>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- Bouton de menu mobile -->
    <button class="mobile-menu-toggle" id="mobile-menu-toggle">
        <i class="fas fa-bars"></i>
    </button>
    
    <!-- Overlay pour le menu mobile -->
    <div class="overlay" id="overlay"></div>
    
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            // Fonction pour faire défiler les messages vers le bas
            function scrollToBottom() {
                var chatMessages = document.getElementById('chat-messages');
                if (chatMessages) {
                    chatMessages.scrollTop = chatMessages.scrollHeight;
                }
            }
            
            // Faire défiler les messages vers le bas au chargement de la page
            scrollToBottom();
            
            // Recherche de contacts
            $('#search-contact').on('input', function() {
                var searchText = $(this).val().toLowerCase();
                
                $('.contact-item').each(function() {
                    var contactName = $(this).find('h4').text().toLowerCase();
                    
                    if (contactName.indexOf(searchText) > -1) {
                        $(this).show();
                    } else {
                        $(this).hide();
                    }
                });
            });
            
            // Envoyer un message via AJAX
            $('#message-form').submit(function(e) {
                e.preventDefault();
                
                var form = $(this);
                var messageInput = form.find('input[name="message"]');
                var message = messageInput.val().trim();
                
                if (message !== '') {
                    $.ajax({
                        type: 'POST',
                        url: form.attr('action'),
                        data: form.serialize(),
                        dataType: 'json',
                        success: function(response) {
                            if (response.success) {
                                // Ajouter le message à la conversation
                                var currentTime = new Date().toLocaleTimeString([], {hour: '2-digit', minute:'2-digit'});
                                
                                var newMessage = `
                                    <div class="message sent">
                                        <div class="message-content">
                                            ${message}
                                            <span class="message-time">${currentTime}</span>
                                        </div>
                                    </div>
                                `;
                                
                                $('#chat-messages').append(newMessage);
                                
                                // Vider le champ de saisie
                                messageInput.val('');
                                
                                // Faire défiler vers le bas
                                scrollToBottom();
                            }
                        }
                    });
                }
            });
            
            // Vérifier les nouveaux messages toutes les 5 secondes
            function checkNewMessages() {
                var contactId = new URLSearchParams(window.location.search).get('contact_id');
                var lastMessageId = $('.message').last().data('message-id') || 0;
                
                if (contactId) {
                    $.ajax({
                        type: 'GET',
                        url: 'check_messages.php',
                        data: { 
                            contact_id: contactId,
                            last_id: lastMessageId
                        },
                        dataType: 'json',
                        success: function(response) {
                            if (response.success && response.messages.length > 0) {
                                // Ajouter les nouveaux messages à la conversation
                                response.messages.forEach(function(msg) {
                                    var messageClass = (msg.sender_id == contactId) ? 'received' : 'sent';
                                    
                                    var newMessage = `
                                        <div class="message ${messageClass}" data-message-id="${msg.id}">
                                            <div class="message-content">
                                                ${msg.message}
                                                <span class="message-time">${msg.created_at}</span>
                                            </div>
                                        </div>
                                    `;
                                    
                                    $('#chat-messages').append(newMessage);
                                });
                                
                                // Faire défiler vers le bas
                                scrollToBottom();
                            }
                        }
                    });
                }
            }
            
            // Vérifier les nouveaux messages toutes les 5 secondes
            setInterval(checkNewMessages, 5000);
            
            // Fonctionnalités des boutons d'action
            
            // Bouton d'appel téléphonique
            $('.chat-actions button:nth-child(1)').click(function() {
                showNotification('Appel téléphonique', 'Fonctionnalité en cours de développement', 'fas fa-phone');
            });
            
            // Bouton d'appel vidéo
            $('.chat-actions button:nth-child(2)').click(function() {
                showNotification('Appel vidéo', 'Fonctionnalité en cours de développement', 'fas fa-video');
            });
            
            // Bouton d'informations
            $('.chat-actions button:nth-child(3)').click(function() {
                var contactId = new URLSearchParams(window.location.search).get('contact_id');
                if (contactId) {
                    window.location.href = 'contact_info.php?id=' + contactId;
                }
            });
            
            // Boutons d'actions pour l'envoi de message
            
            // Bouton d'ajout (plus)
            $('.input-actions button:nth-child(1)').click(function() {
                showNotification('Ajouter du contenu', 'Fonctionnalité en cours de développement', 'fas fa-plus-circle');
            });
            
            // Bouton d'envoi d'image
            $('.input-actions button:nth-child(2)').click(function() {
                $('#file-upload').click();
            });
            
            // Bouton d'envoi de pièce jointe
            $('.input-actions button:nth-child(3)').click(function() {
                $('#attachment-upload').click();
            });
            
            // Gestion des fichiers uploadés
            $('#file-upload').change(function() {
                var file = this.files[0];
                if (file) {
                    var formData = new FormData();
                    formData.append('file', file);
                    formData.append('receiver_id', $('input[name="receiver_id"]').val());
                    formData.append('type', 'image');
                    formData.append('csrf_token', $('input[name="csrf_token"]').val());
                    
                    $.ajax({
                        url: 'upload_file.php',
                        type: 'POST',
                        data: formData,
                        processData: false,
                        contentType: false,
                        success: function(response) {
                            if (response.success) {
                                // Ajouter l'image à la conversation
                                var currentTime = new Date().toLocaleTimeString([], {hour: '2-digit', minute:'2-digit'});
                                
                                var newMessage = `
                                    <div class="message sent">
                                        <div class="message-content">
                                            <img src="${response.file_url}" alt="Image envoyée" class="message-image">
                                            <span class="message-time">${currentTime}</span>
                                        </div>
                                    </div>
                                `;
                                
                                $('#chat-messages').append(newMessage);
                                scrollToBottom();
                            } else {
                                showNotification('Erreur', 'Erreur lors de l\'envoi de l\'image', 'fas fa-exclamation-circle');
                            }
                        },
                        error: function() {
                            showNotification('Erreur', 'Erreur lors de l\'envoi de l\'image', 'fas fa-exclamation-circle');
                        }
                    });
                }
            });
            
            // Gestion des pièces jointes
            $('#attachment-upload').change(function() {
                var file = this.files[0];
                if (file) {
                    var formData = new FormData();
                    formData.append('file', file);
                    formData.append('receiver_id', $('input[name="receiver_id"]').val());
                    formData.append('type', 'file');
                    formData.append('csrf_token', $('input[name="csrf_token"]').val());
                    
                    $.ajax({
                        url: 'upload_file.php',
                        type: 'POST',
                        data: formData,
                        processData: false,
                        contentType: false,
                        success: function(response) {
                            if (response.success) {
                                // Ajouter le fichier à la conversation
                                var currentTime = new Date().toLocaleTimeString([], {hour: '2-digit', minute:'2-digit'});
                                
                                var newMessage = `
                                    <div class="message sent">
                                        <div class="message-content">
                                            <a href="${response.file_url}" target="_blank" class="message-file">
                                                <i class="fas fa-file"></i> ${file.name}
                                            </a>
                                            <span class="message-time">${currentTime}</span>
                                        </div>
                                    </div>
                                `;
                                
                                $('#chat-messages').append(newMessage);
                                scrollToBottom();
                            } else {
                                showNotification('Erreur', 'Erreur lors de l\'envoi du fichier', 'fas fa-exclamation-circle');
                            }
                        },
                        error: function() {
                            showNotification('Erreur', 'Erreur lors de l\'envoi du fichier', 'fas fa-exclamation-circle');
                        }
                    });
                }
            });
            
            // Supprimer un message (clic droit)
            $(document).on('contextmenu', '.message.sent', function(e) {
                e.preventDefault();
                
                var messageId = $(this).data('message-id');
                if (confirm('Voulez-vous supprimer ce message ?')) {
                    $.ajax({
                        url: 'delete_message.php',
                        type: 'POST',
                        data: { 
                            message_id: messageId,
                            csrf_token: $('input[name="csrf_token"]').val()
                        },
                        dataType: 'json',
                        success: function(response) {
                            if (response.success) {
                                // Supprimer le message de l'interface
                                $(`[data-message-id="${messageId}"]`).fadeOut(300, function() {
                                    $(this).remove();
                                });
                            } else {
                                showNotification('Erreur', 'Erreur lors de la suppression du message', 'fas fa-exclamation-circle');
                            }
                        }
                    });
                }
            });
            
            // Indicateur de frappe
            var typingTimer;
            var isTyping = false;
            
            $('.chat-input input[name="message"]').on('input', function() {
                var contactId = new URLSearchParams(window.location.search).get('contact_id');
                
                if (!isTyping) {
                    isTyping = true;
                    // Envoyer l'état de frappe au serveur
                    $.ajax({
                        url: 'typing_status.php',
                        type: 'POST',
                        data: {
                            contact_id: contactId,
                            is_typing: 1,
                            csrf_token: $('input[name="csrf_token"]').val()
                        }
                    });
                }
                
                clearTimeout(typingTimer);
                typingTimer = setTimeout(function() {
                    isTyping = false;
                    // Envoyer l'état de frappe au serveur
                    $.ajax({
                        url: 'typing_status.php',
                        type: 'POST',
                        data: {
                            contact_id: contactId,
                            is_typing: 0,
                            csrf_token: $('input[name="csrf_token"]').val()
                        }
                    });
                }, 2000);
            });
            
            // Vérifier l'état de frappe du contact
            function checkTypingStatus() {
                var contactId = new URLSearchParams(window.location.search).get('contact_id');
                
                if (contactId) {
                    $.ajax({
                        url: 'check_typing.php',
                        type: 'GET',
                        data: {
                            contact_id: contactId
                        },
                        dataType: 'json',
                        success: function(response) {
                            if (response.is_typing) {
                                // Afficher l'indicateur de frappe
                                if ($('.typing-indicator').length === 0) {
                                    $('.chat-header .contact-info .status').html('<span class="typing-indicator">En train d\'écrire</span>');
                                }
                            } else {
                                // Masquer l'indicateur de frappe
                                $('.typing-indicator').remove();
                                // Restaurer le statut
                                if (response.is_online) {
                                    $('.chat-header .contact-info .status').text('En ligne');
                                } else {
                                    $('.chat-header .contact-info .status').text('Dernière connexion: ' + response.last_login);
                                }
                            }
                        }
                    });
                }
            }
            
            // Vérifier l'état de frappe toutes les 2 secondes
            setInterval(checkTypingStatus, 2000);
            
            // Gestion du menu mobile
            $('#mobile-menu-toggle').click(function() {
                $('.sidebar').toggleClass('active');
                $('#overlay').toggleClass('active');
            });
            
            $('#overlay').click(function() {
                $('.sidebar').removeClass('active');
                $('#overlay').removeClass('active');
            });
            
            // Fonction pour afficher une notification
            function showNotification(title, message, icon) {
                // Supprimer les notifications existantes
                $('.notification').remove();
                
                // Créer la notification
                var notification = `
                    <div class="notification">
                        <div class="notification-icon">
                            <i class="${icon}"></i>
                        </div>
                        <div class="notification-content">
                            <div class="notification-title">${title}</div>
                            <div class="notification-message">${message}</div>
                        </div>
                        <button class="notification-close">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                `;
                
                // Ajouter la notification au body
                $('body').append(notification);
                
                // Afficher la notification
                setTimeout(function() {
                    $('.notification').addClass('show');
                }, 100);
                
                // Masquer la notification après 3 secondes
                setTimeout(function() {
                    $('.notification').removeClass('show');
                    setTimeout(function() {
                        $('.notification').remove();
                    }, 300);
                }, 3000);
                
                // Fermer la notification en cliquant sur le bouton
                $(document).on('click', '.notification-close', function() {
                    $('.notification').removeClass('show');
                    setTimeout(function() {
                        $('.notification').remove();
                    }, 300);
                });
            }
        });
    </script>
</body>
</html>