<?php
session_start();

// Vérifier si l'utilisateur est connecté
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// Vérifier si la requête est de type POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("HTTP/1.1 405 Method Not Allowed");
    exit();
}

// Vérifier le jeton CSRF
if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
    header("HTTP/1.1 403 Forbidden");
    exit();
}

// Inclure les fichiers nécessaires
include_once "config/database.php";
include_once "models/Message.php";

// Récupérer les données du formulaire
$sender_id = $_SESSION['user_id'];
$receiver_id = isset($_POST['receiver_id']) ? $_POST['receiver_id'] : null;
$message_text = isset($_POST['message']) ? $_POST['message'] : null;

// Vérifier si les données sont valides
if (!$receiver_id || !$message_text) {
    header("HTTP/1.1 400 Bad Request");
    exit();
}

// Instancier la base de données
$database = new Database();
$db = $database->getConnection();

// Nettoyer les données
$receiver_id = filter_var($receiver_id, FILTER_SANITIZE_NUMBER_INT);
$message_text = $database->escapeString($message_text);

// Instancier l'objet Message
$message = new Message($db);

// Définir les valeurs des propriétés du message
$message->sender_id = $sender_id;
$message->receiver_id = $receiver_id;
$message->message = $message_text;

// Créer le message
if ($message->create()) {
    // Si la requête est AJAX, renvoyer une réponse JSON
    if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
        header('Content-Type: application/json');
        echo json_encode(['success' => true]);
        exit();
    }
    
    // Sinon, rediriger vers la page de conversation
    header("Location: index.php?contact_id=" . $receiver_id);
    exit();
} else {
    // Si la requête est AJAX, renvoyer une réponse JSON
    if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
        header('Content-Type: application/json');
        echo json_encode(['success' => false, 'message' => 'Erreur lors de l\'envoi du message.']);
        exit();
    }
    
    // Sinon, rediriger vers la page de conversation avec un message d'erreur
    header("Location: index.php?contact_id=" . $receiver_id . "&error=1");
    exit();
}
?>