<?php
session_start();

// Vérifier si l'utilisateur est connecté
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// Inclure les fichiers nécessaires
include_once "config/database.php";
include_once "models/User.php";

// Instancier la base de données
$database = new Database();
$db = $database->getConnection();

// Instancier l'objet User
$user = new User($db);
$user->id = $_SESSION['user_id'];
$user->readOne();

// Initialiser les variables
$success_message = "";
$error_message = "";
$active_tab = isset($_GET['tab']) ? $_GET['tab'] : 'general';

// Traitement du formulaire lors de la soumission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    
    // Vérifier quelle action a été demandée
    if (isset($_POST['update_general'])) {
        // Mise à jour des paramètres généraux
        $theme = isset($_POST['theme']) ? $_POST['theme'] : 'light';
        $notifications = isset($_POST['notifications']) ? 1 : 0;
        $sounds = isset($_POST['sounds']) ? 1 : 0;
        
        // Mettre à jour les préférences de l'utilisateur
        if ($user->updatePreferences($theme, $notifications, $sounds)) {
            $success_message = "Vos paramètres généraux ont été mis à jour avec succès.";
            $active_tab = 'general';
        } else {
            $error_message = "Une erreur s'est produite lors de la mise à jour des paramètres.";
            $active_tab = 'general';
        }
    } 
    elseif (isset($_POST['update_privacy'])) {
        // Mise à jour des paramètres de confidentialité
        $show_status = isset($_POST['show_status']) ? 1 : 0;
        $read_receipts = isset($_POST['read_receipts']) ? 1 : 0;
        $typing_indicator = isset($_POST['typing_indicator']) ? 1 : 0;
        
        // Mettre à jour les paramètres de confidentialité
        if ($user->updatePrivacySettings($show_status, $read_receipts, $typing_indicator)) {
            $success_message = "Vos paramètres de confidentialité ont été mis à jour avec succès.";
            $active_tab = 'privacy';
        } else {
            $error_message = "Une erreur s'est produite lors de la mise à jour des paramètres.";
            $active_tab = 'privacy';
        }
    }
    elseif (isset($_POST['update_security'])) {
        // Mise à jour des paramètres de sécurité
        $current_password = trim($_POST['current_password']);
        $new_password = trim($_POST['new_password']);
        $confirm_password = trim($_POST['confirm_password']);
        
        // Vérifier si les champs sont remplis
        if (empty($current_password)) {
            $error_message = "Veuillez entrer votre mot de passe actuel.";
            $active_tab = 'security';
        } elseif (empty($new_password)) {
            $error_message = "Veuillez entrer un nouveau mot de passe.";
            $active_tab = 'security';
        } elseif (strlen($new_password) < 6) {
            $error_message = "Le mot de passe doit contenir au moins 6 caractères.";
            $active_tab = 'security';
        } elseif ($new_password !== $confirm_password) {
            $error_message = "Les mots de passe ne correspondent pas.";
            $active_tab = 'security';
        } else {
            // Vérifier le mot de passe actuel
            if ($user->verifyPassword($current_password)) {
                // Mettre à jour le mot de passe
                $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
                if ($user->updatePassword($hashed_password)) {
                    $success_message = "Votre mot de passe a été mis à jour avec succès.";
                    $active_tab = 'security';
                } else {
                    $error_message = "Une erreur s'est produite lors de la mise à jour du mot de passe.";
                    $active_tab = 'security';
                }
            } else {
                $error_message = "Le mot de passe actuel est incorrect.";
                $active_tab = 'security';
            }
        }
    }
    elseif (isset($_POST['update_view'])) {
        // Mise à jour des paramètres d'affichage
        $font_size = isset($_POST['font_size']) ? $_POST['font_size'] : 'medium';
        $message_alignment = isset($_POST['message_alignment']) ? $_POST['message_alignment'] : 'standard';
        $bubble_style = isset($_POST['bubble_style']) ? $_POST['bubble_style'] : 'rounded';
        $compact_mode = isset($_POST['compact_mode']) ? 1 : 0;
        $show_avatars = isset($_POST['show_avatars']) ? 1 : 0;
        
        // Mettre à jour les paramètres d'affichage (à implémenter dans la classe User)
        // Pour l'instant, nous simulons une mise à jour réussie
        $success_message = "Vos paramètres d'affichage ont été mis à jour avec succès.";
        $active_tab = 'view';
    }
    elseif (isset($_POST['update_personalization'])) {
        // Mise à jour des paramètres de personnalisation
        $accent_color = isset($_POST['accent_color']) ? $_POST['accent_color'] : '#7e3ff2';
        $background_style = isset($_POST['background_style']) ? $_POST['background_style'] : 'default';
        $custom_background = isset($_POST['custom_background']) ? $_POST['custom_background'] : '';
        $emoji_style = isset($_POST['emoji_style']) ? $_POST['emoji_style'] : 'standard';
        
        // Mettre à jour les paramètres de personnalisation (à implémenter dans la classe User)
        // Pour l'instant, nous simulons une mise à jour réussie
        $success_message = "Vos paramètres de personnalisation ont été mis à jour avec succès.";
        $active_tab = 'personalization';
    }
    elseif (isset($_POST['update_automation'])) {
        // Mise à jour des paramètres d'automatisation
        $auto_reply = isset($_POST['auto_reply']) ? 1 : 0;
        $auto_reply_message = isset($_POST['auto_reply_message']) ? $_POST['auto_reply_message'] : '';
        $scheduled_messages = isset($_POST['scheduled_messages']) ? 1 : 0;
        $message_templates = isset($_POST['message_templates']) ? 1 : 0;
        
        // Mettre à jour les paramètres d'automatisation (à implémenter dans la classe User)
        // Pour l'instant, nous simulons une mise à jour réussie
        $success_message = "Vos paramètres d'automatisation ont été mis à jour avec succès.";
        $active_tab = 'automation';
    }
    elseif (isset($_POST['update_admin'])) {
        // Mise à jour des paramètres d'administration
        $user_management = isset($_POST['user_management']) ? 1 : 0;
        $content_moderation = isset($_POST['content_moderation']) ? 1 : 0;
        $system_logs = isset($_POST['system_logs']) ? 1 : 0;
        
        // Mettre à jour les paramètres d'administration (à implémenter dans la classe User)
        // Pour l'instant, nous simulons une mise à jour réussie
        $success_message = "Vos paramètres d'administration ont été mis à jour avec succès.";
        $active_tab = 'admin';
    }
    
    // Recharger les informations de l'utilisateur après la mise à jour
    $user->readOne();
}

// Récupérer les préférences de l'utilisateur
$preferences = $user->getPreferences();

// Simuler des préférences d'affichage (à remplacer par une vraie implémentation)
$view_preferences = [
    'font_size' => 'medium',
    'message_alignment' => 'standard',
    'bubble_style' => 'rounded',
    'compact_mode' => 0,
    'show_avatars' => 1
];

// Simuler des préférences de personnalisation
$personalization_preferences = [
    'accent_color' => '#7e3ff2',
    'background_style' => 'default',
    'custom_background' => '',
    'emoji_style' => 'standard'
];

// Simuler des préférences d'automatisation
$automation_preferences = [
    'auto_reply' => 0,
    'auto_reply_message' => 'Je suis actuellement absent, je vous répondrai dès que possible.',
    'scheduled_messages' => 0,
    'message_templates' => 0
];

// Simuler des préférences d'administration
$admin_preferences = [
    'user_management' => 1,
    'content_moderation' => 1,
    'system_logs' => 1
];
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Paramètres - Aurore</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet">
    <meta name="robots" content="noindex, nofollow">
    <meta http-equiv="Content-Security-Policy" content="default-src 'self'; script-src 'self' 'unsafe-inline' https://code.jquery.com; style-src 'self' 'unsafe-inline' https://cdnjs.cloudflare.com; img-src 'self' data:; font-src 'self' https://cdnjs.cloudflare.com;">
    
    <!-- Inclure les styles des paramètres -->
    <?php include_once "settings/styles.php"; ?>
</head>
<body>
    <div class="messenger-container">
        <!-- Sidebar avec la liste des contacts -->
        <div class="sidebar">
            <div class="user-profile">
                <img src="<?php echo $user->profile_image ? 'uploads/profile/' . $user->profile_image : 'assets/images/default-avatar.png'; ?>" alt="Profile">
                <div class="user-info">
                    <h3><?php echo $user->firstname . ' ' . $user->lastname; ?></h3>
                    <div class="status online">
                        <span class="status-dot"></span>
                        <span class="status-text">En ligne</span>
                    </div>
                </div>
                <div class="user-actions">
                    <a href="index.php" title="Messages" class="tooltip" data-tooltip="Messages"><i class="fas fa-comment"></i></a>
                    <a href="profile.php" title="Profil" class="tooltip" data-tooltip="Profil"><i class="fas fa-user"></i></a>
                    <a href="logout.php" title="Déconnexion" class="tooltip" data-tooltip="Déconnexion"><i class="fas fa-sign-out-alt"></i></a>
                </div>
            </div>
            
            <div class="search-box">
                <i class="fas fa-search"></i>
                <input type="text" placeholder="Rechercher..." id="search-contact">
            </div>
            
            <div class="contacts-list">
                <!-- Liste des contacts sera chargée dynamiquement -->
            </div>
        </div>
        
        <!-- Zone principale des paramètres -->
        <div class="settings-area">
            <div class="settings-header">
                <h2>Paramètres</h2>
                <a href="index.php" class="back-button"><i class="fas fa-arrow-left"></i> Retour aux messages</a>
            </div>
            
            <div class="settings-content">
                <?php if (!empty($success_message)): ?>
                    <div class="alert alert-success"><?php echo $success_message; ?></div>
                <?php endif; ?>
                
                <?php if (!empty($error_message)): ?>
                    <div class="alert alert-danger"><?php echo $error_message; ?></div>
                <?php endif; ?>
                
                <div class="settings-tabs">
                    <button class="tab-button <?php echo $active_tab === 'general' ? 'active' : ''; ?>" data-tab="general">Général</button>
                    <button class="tab-button <?php echo $active_tab === 'privacy' ? 'active' : ''; ?>" data-tab="privacy">Confidentialité</button>
                    <button class="tab-button <?php echo $active_tab === 'security' ? 'active' : ''; ?>" data-tab="security">Sécurité</button>
                    <button class="tab-button <?php echo $active_tab === 'view' ? 'active' : ''; ?>" data-tab="view">Voir</button>
                    <button class="tab-button <?php echo $active_tab === 'personalization' ? 'active' : ''; ?>" data-tab="personalization">Personnaliser</button>
                    <button class="tab-button <?php echo $active_tab === 'automation' ? 'active' : ''; ?>" data-tab="automation">Automatique</button>
                    <button class="tab-button <?php echo $active_tab === 'admin' ? 'active' : ''; ?>" data-tab="admin">Admin</button>
                </div>
                
                <div class="settings-tab-content">
                    <!-- Inclure les onglets de paramètres -->
                    <?php include_once "settings/general.php"; ?>
                    <?php include_once "settings/privacy.php"; ?>
                    <?php include_once "settings/security.php"; ?>
                    <?php include_once "settings/view.php"; ?>
                    <?php include_once "settings/personalization.php"; ?>
                    <?php include_once "settings/automation.php"; ?>
                    <?php include_once "settings/admin.php"; ?>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Inclure les scripts des paramètres -->
    <?php include_once "settings/scripts.php"; ?>
</body>
</html>