<?php
// Vérifier si l'utilisateur est connecté directement
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}

// Traitement du formulaire d'automatisation
if (isset($_POST['update_automation'])) {
    // Mise à jour des paramètres d'automatisation
    $auto_reply = isset($_POST['auto_reply']) ? 1 : 0;
    $auto_reply_message = isset($_POST['auto_reply_message']) ? $_POST['auto_reply_message'] : '';
    $scheduled_messages = isset($_POST['scheduled_messages']) ? 1 : 0;
    $message_templates = isset($_POST['message_templates']) ? 1 : 0;
    
    // Mettre à jour les paramètres d'automatisation (à implémenter dans la classe User)
    // Pour l'instant, nous simulons une mise à jour réussie
    $success_message = "Vos paramètres d'automatisation ont été mis à jour avec succès.";
    $active_tab = 'automation';
}
?>

<div class="tab-pane <?php echo $active_tab === 'automation' ? 'active' : ''; ?>" id="automation">
    <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post" class="settings-form">
        <h3>Paramètres d'automatisation</h3>
        
        <div class="form-group">
            <label class="checkbox-label">
                <input type="checkbox" name="auto_reply" id="auto_reply" <?php echo ($automation_preferences['auto_reply'] == 1) ? 'checked' : ''; ?>>
                Activer la réponse automatique
            </label>
            <p class="form-text">Envoyer automatiquement une réponse lorsque vous êtes absent</p>
        </div>
        
        <div class="form-group auto-reply-message" style="<?php echo ($automation_preferences['auto_reply'] == 1) ? '' : 'display: none;'; ?>">
            <label for="auto_reply_message">Message de réponse automatique</label>
            <textarea id="auto_reply_message" name="auto_reply_message" class="form-control" rows="3"><?php echo $automation_preferences['auto_reply_message']; ?></textarea>
            <p class="form-text">Ce message sera envoyé automatiquement en réponse aux nouveaux messages</p>
        </div>
        
        <div class="form-group">
            <label class="checkbox-label">
                <input type="checkbox" name="scheduled_messages" <?php echo ($automation_preferences['scheduled_messages'] == 1) ? 'checked' : ''; ?>>
                Activer les messages programmés
            </label>
            <p class="form-text">Planifier l'envoi de messages à une date et heure spécifiques</p>
        </div>
        
        <div class="form-group">
            <label class="checkbox-label">
                <input type="checkbox" name="message_templates" id="message_templates" <?php echo ($automation_preferences['message_templates'] == 1) ? 'checked' : ''; ?>>
                Activer les modèles de messages
            </label>
            <p class="form-text">Créer et utiliser des modèles de messages prédéfinis</p>
        </div>
        
        <div class="templates-container" style="<?php echo ($automation_preferences['message_templates'] == 1) ? '' : 'display: none;'; ?>">
            <h4>Modèles de messages</h4>
            
            <div class="template-list">
                <div class="template-item">
                    <div class="template-content">
                        <div class="template-name">Salutation</div>
                        <div class="template-text">Bonjour, comment allez-vous aujourd'hui ?</div>
                    </div>
                    <div class="template-actions">
                        <button type="button" class="btn-icon edit-template" title="Modifier"><i class="fas fa-edit"></i></button>
                        <button type="button" class="btn-icon delete-template" title="Supprimer"><i class="fas fa-trash"></i></button>
                    </div>
                </div>
                
                <div class="template-item">
                    <div class="template-content">
                        <div class="template-name">Réunion</div>
                        <div class="template-text">Pouvons-nous organiser une réunion pour discuter de ce sujet ?</div>
                    </div>
                    <div class="template-actions">
                        <button type="button" class="btn-icon edit-template" title="Modifier"><i class="fas fa-edit"></i></button>
                        <button type="button" class="btn-icon delete-template" title="Supprimer"><i class="fas fa-trash"></i></button>
                    </div>
                </div>
                
                <div class="template-item">
                    <div class="template-content">
                        <div class="template-name">Remerciement</div>
                        <div class="template-text">Merci beaucoup pour votre aide, c'est très apprécié !</div>
                    </div>
                    <div class="template-actions">
                        <button type="button" class="btn-icon edit-template" title="Modifier"><i class="fas fa-edit"></i></button>
                        <button type="button" class="btn-icon delete-template" title="Supprimer"><i class="fas fa-trash"></i></button>
                    </div>
                </div>
            </div>
            
            <button type="button" class="btn btn-secondary add-template-btn">
                <i class="fas fa-plus"></i> Ajouter un modèle
            </button>
        </div>
        
        <div class="automation-info">
            <h4>Fonctionnalités d'automatisation</h4>
            <p>Les fonctionnalités d'automatisation vous permettent de gagner du temps et d'améliorer votre efficacité dans vos communications.</p>
            
            <div class="automation-features">
                <div class="automation-feature">
                    <i class="fas fa-reply"></i>
                    <h5>Réponses automatiques</h5>
                    <p>Envoyez automatiquement des réponses lorsque vous êtes absent ou indisponible.</p>
                </div>
                
                <div class="automation-feature">
                    <i class="fas fa-clock"></i>
                    <h5>Messages programmés</h5>
                    <p>Planifiez l'envoi de messages à une date et heure spécifiques.</p>
                </div>
                
                <div class="automation-feature">
                    <i class="fas fa-file-alt"></i>
                    <h5>Modèles de messages</h5>
                    <p>Créez et utilisez des modèles pour vos messages fréquents.</p>
                </div>
            </div>
        </div>
        
        <div class="form-group" style="margin-top: 20px;">
            <button type="submit" name="update_automation" class="btn btn-primary">
                <i class="fas fa-save"></i> Enregistrer les modifications
            </button>
        </div>
    </form>
</div>