<?php
// Vérifier si l'utilisateur est connecté directement
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}

// Traitement du formulaire de personnalisation
if (isset($_POST['update_personalization'])) {
    // Mise à jour des paramètres de personnalisation
    $accent_color = isset($_POST['accent_color']) ? $_POST['accent_color'] : '#7e3ff2';
    $background_style = isset($_POST['background_style']) ? $_POST['background_style'] : 'default';
    $custom_background = isset($_POST['custom_background']) ? $_POST['custom_background'] : '';
    $emoji_style = isset($_POST['emoji_style']) ? $_POST['emoji_style'] : 'standard';
    
    // Mettre à jour les paramètres de personnalisation (à implémenter dans la classe User)
    // Pour l'instant, nous simulons une mise à jour réussie
    $success_message = "Vos paramètres de personnalisation ont été mis à jour avec succès.";
    $active_tab = 'personalization';
}
?>

<div class="tab-pane <?php echo $active_tab === 'personalization' ? 'active' : ''; ?>" id="personalization">
    <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post" class="settings-form">
        <h3>Personnalisation de l'interface</h3>
        
        <div class="form-group">
            <label for="accent_color">Couleur d'accent</label>
            <div class="color-picker-container">
                <input type="color" id="accent_color" name="accent_color" class="color-picker" value="<?php echo $personalization_preferences['accent_color']; ?>">
                <div class="color-preview" style="background-color: <?php echo $personalization_preferences['accent_color']; ?>"></div>
                <span class="color-value"><?php echo $personalization_preferences['accent_color']; ?></span>
            </div>
            <p class="form-text">Cette couleur sera utilisée pour les éléments principaux de l'interface</p>
        </div>
        
        <div class="form-group">
            <label>Style d'arrière-plan</label>
            <div class="background-options">
                <label class="background-option <?php echo ($personalization_preferences['background_style'] === 'default') ? 'selected' : ''; ?>">
                    <input type="radio" name="background_style" value="default" <?php echo ($personalization_preferences['background_style'] === 'default') ? 'checked' : ''; ?>>
                    <div class="background-preview default-bg">
                        <span>Par défaut</span>
                    </div>
                </label>
                <label class="background-option <?php echo ($personalization_preferences['background_style'] === 'gradient') ? 'selected' : ''; ?>">
                    <input type="radio" name="background_style" value="gradient" <?php echo ($personalization_preferences['background_style'] === 'gradient') ? 'checked' : ''; ?>>
                    <div class="background-preview gradient-bg">
                        <span>Dégradé</span>
                    </div>
                </label>
                <label class="background-option <?php echo ($personalization_preferences['background_style'] === 'aurora') ? 'selected' : ''; ?>">
                    <input type="radio" name="background_style" value="aurora" <?php echo ($personalization_preferences['background_style'] === 'aurora') ? 'checked' : ''; ?>>
                    <div class="background-preview aurora-bg">
                        <span>Aurore</span>
                    </div>
                </label>
                <label class="background-option <?php echo ($personalization_preferences['background_style'] === 'custom') ? 'selected' : ''; ?>">
                    <input type="radio" name="background_style" value="custom" <?php echo ($personalization_preferences['background_style'] === 'custom') ? 'checked' : ''; ?>>
                    <div class="background-preview custom-bg">
                        <span>Personnalisé</span>
                    </div>
                </label>
            </div>
        </div>
        
        <div class="form-group custom-background-group" style="<?php echo ($personalization_preferences['background_style'] === 'custom') ? '' : 'display: none;'; ?>">
            <label for="custom_background">URL d'image d'arrière-plan personnalisée</label>
            <input type="text" id="custom_background" name="custom_background" class="form-control" value="<?php echo $personalization_preferences['custom_background']; ?>" placeholder="https://exemple.com/image.jpg">
            <p class="form-text">Entrez l'URL d'une image pour l'utiliser comme arrière-plan</p>
        </div>
        
        <div class="form-group">
            <label>Style d'emoji</label>
            <div class="emoji-options">
                <label class="emoji-option <?php echo ($personalization_preferences['emoji_style'] === 'standard') ? 'selected' : ''; ?>">
                    <input type="radio" name="emoji_style" value="standard" <?php echo ($personalization_preferences['emoji_style'] === 'standard') ? 'checked' : ''; ?>>
                    <div class="emoji-preview">
                        <span class="emoji-sample">😊 😂 😍</span>
                        <span class="emoji-name">Standard</span>
                    </div>
                </label>
                <label class="emoji-option <?php echo ($personalization_preferences['emoji_style'] === 'twitter') ? 'selected' : ''; ?>">
                    <input type="radio" name="emoji_style" value="twitter" <?php echo ($personalization_preferences['emoji_style'] === 'twitter') ? 'checked' : ''; ?>>
                    <div class="emoji-preview">
                        <span class="emoji-sample">😊 😂 😍</span>
                        <span class="emoji-name">Twitter</span>
                    </div>
                </label>
                <label class="emoji-option <?php echo ($personalization_preferences['emoji_style'] === 'facebook') ? 'selected' : ''; ?>">
                    <input type="radio" name="emoji_style" value="facebook" <?php echo ($personalization_preferences['emoji_style'] === 'facebook') ? 'checked' : ''; ?>>
                    <div class="emoji-preview">
                        <span class="emoji-sample">😊 😂 😍</span>
                        <span class="emoji-name">Facebook</span>
                    </div>
                </label>
            </div>
        </div>
        
        <div class="preview-container">
            <h4 class="preview-title">Aperçu de personnalisation</h4>
            <div class="personalization-preview" style="--accent-color: <?php echo $personalization_preferences['accent_color']; ?>">
                <div class="preview-header">
                    <div class="preview-avatar"></div>
                    <div class="preview-name">John Doe</div>
                    <div class="preview-status">En ligne</div>
                </div>
                <div class="preview-messages">
                    <div class="preview-message received">Bonjour, comment vas-tu ?</div>
                    <div class="preview-message sent">Très bien, merci ! Et toi ?</div>
                    <div class="preview-message received">Super ! On se voit plus tard ?</div>
                </div>
                <div class="preview-input">
                    <input type="text" placeholder="Écrivez un message..." readonly>
                    <button><i class="fas fa-paper-plane"></i></button>
                </div>
            </div>
        </div>
        
        <div class="form-group" style="margin-top: 20px;">
            <button type="submit" name="update_personalization" class="btn btn-primary">
                <i class="fas fa-save"></i> Enregistrer les modifications
            </button>
        </div>
    </form>
</div>