<?php
// Ce fichier contient les scripts JavaScript pour les paramètres
?>
<script>
    $(document).ready(function() {
        // Gestion des onglets
        $('.tab-button').click(function(e) {
            e.preventDefault();
            var tabId = $(this).data('tab');
            
            // Activer le bouton d'onglet
            $('.tab-button').removeClass('active');
            $(this).addClass('active');
            
            // Afficher le contenu de l'onglet
            $('.tab-pane').removeClass('active');
            $('#' + tabId).addClass('active');
            
            // Mettre à jour l'URL avec le paramètre d'onglet
            history.pushState(null, null, '?tab=' + tabId);
        });
        
        // Vérification de la force du mot de passe
        $('#new_password').on('input', function() {
            var password = $(this).val();
            var strength = 0;
            
            // Longueur minimale
            if (password.length >= 8) strength += 1;
            
            // Lettres majuscules et minuscules
            if (/[a-z]/.test(password) && /[A-Z]/.test(password)) strength += 1;
            
            // Chiffres
            if (/[0-9]/.test(password)) strength += 1;
            
            // Caractères spéciaux
            if (/[^a-zA-Z0-9]/.test(password)) strength += 1;
            
            // Mettre à jour l'indicateur de force
            var indicator = $('.password-strength-indicator');
            var strengthText = $('#strength-text');
            var width = (strength / 4) * 100;
            indicator.css('width', width + '%');
            
            // Changer la couleur et le texte en fonction de la force
            if (password.length === 0) {
                indicator.css('background-color', '#eee');
                strengthText.text('Non défini');
                strengthText.css('color', '#777');
            } else if (strength < 2) {
                indicator.css('background-color', '#e74c3c'); // Rouge
                strengthText.text('Faible');
                strengthText.css('color', '#e74c3c');
            } else if (strength < 3) {
                indicator.css('background-color', '#f39c12'); // Orange
                strengthText.text('Moyen');
                strengthText.css('color', '#f39c12');
            } else if (strength < 4) {
                indicator.css('background-color', '#3498db'); // Bleu
                strengthText.text('Bon');
                strengthText.css('color', '#3498db');
            } else {
                indicator.css('background-color', '#2ecc71'); // Vert
                strengthText.text('Excellent');
                strengthText.css('color', '#2ecc71');
            }
        });
        
        // Vérifier si les mots de passe correspondent
        $('#confirm_password').on('input', function() {
            var newPassword = $('#new_password').val();
            var confirmPassword = $(this).val();
            
            if (newPassword === confirmPassword) {
                $(this).css('border-color', '#2ecc71');
            } else {
                $(this).css('border-color', '#e74c3c');
            }
        });
        
        // Animation pour les messages d'alerte
        $('.alert').fadeIn(300).delay(5000).fadeOut(500);
        
        // Charger les contacts
        $.ajax({
            url: 'get_contacts.php',
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                if (response.success && response.contacts.length > 0) {
                    var contactsHtml = '';
                    
                    response.contacts.forEach(function(contact) {
                        var statusClass = contact.is_online ? 'online' : 'offline';
                        var unreadBadge = contact.unread_count > 0 ? '<span class="unread-count">' + contact.unread_count + '</span>' : '';
                        
                        contactsHtml += `
                            <a href="index.php?contact_id=${contact.id}" class="contact-item">
                                <div class="contact-avatar">
                                    <img src="${contact.profile_image ? 'uploads/profile/' + contact.profile_image : 'assets/images/default-avatar.png'}" alt="${contact.firstname}">
                                    <span class="status-indicator ${statusClass}"></span>
                                </div>
                                <div class="contact-info">
                                    <h4>${contact.firstname} ${contact.lastname}</h4>
                                    <p class="last-message">${contact.last_message}</p>
                                </div>
                                <div class="contact-meta">
                                    ${contact.last_message_time ? '<span class="time">' + contact.last_message_time + '</span>' : ''}
                                    ${unreadBadge}
                                </div>
                            </a>
                        `;
                    });
                    
                    $('.contacts-list').html(contactsHtml);
                } else {
                    $('.contacts-list').html('<div class="empty-contacts"><p>Aucun contact disponible</p></div>');
                }
            },
            error: function() {
                $('.contacts-list').html('<div class="empty-contacts"><p>Erreur lors du chargement des contacts</p></div>');
            }
        });
        
        // Recherche de contacts
        $('#search-contact').on('input', function() {
            var searchText = $(this).val().toLowerCase();
            
            $('.contact-item').each(function() {
                var contactName = $(this).find('h4').text().toLowerCase();
                
                if (contactName.indexOf(searchText) > -1) {
                    $(this).show();
                } else {
                    $(this).hide();
                }
            });
        });
        
        // Mise à jour de l'aperçu des paramètres d'affichage
        function updatePreview() {
            var fontSize = $('input[name="font_size"]:checked').val() || 'medium';
            var messageAlignment = $('input[name="message_alignment"]:checked').val() || 'standard';
            var bubbleStyle = $('input[name="bubble_style"]:checked').val() || 'rounded';
            var compactMode = $('input[name="compact_mode"]').is(':checked');
            var showAvatars = $('input[name="show_avatars"]').is(':checked');
            
            var preview = $('#message-preview');
            
            // Mettre à jour la taille de police
            preview.removeClass('font-small font-medium font-large');
            preview.addClass('font-' + fontSize);
            
            // Mettre à jour l'alignement
            preview.removeClass('alignment-standard alignment-centered alignment-right');
            preview.addClass('alignment-' + messageAlignment);
            
            // Mettre à jour le style des bulles
            preview.find('.preview-message').removeClass('bubble-square bubble-rounded bubble-modern');
            preview.find('.preview-message').addClass('bubble-' + bubbleStyle);
            
            // Mettre à jour le mode compact
            if (compactMode) {
                preview.addClass('compact-mode');
            } else {
                preview.removeClass('compact-mode');
            }
            
            // Mettre à jour l'affichage des avatars
            if (showAvatars) {
                // Ajouter les avatars s'ils n'existent pas
                if (preview.find('.message-with-avatar').length === 0) {
                    preview.find('.preview-message.received').each(function() {
                        $(this).wrap('<div class="message-with-avatar"></div>');
                        $(this).parent().prepend('<div class="preview-avatar">J</div>');
                    });
                }
            } else {
                // Supprimer les avatars s'ils existent
                preview.find('.message-with-avatar').each(function() {
                    var message = $(this).find('.preview-message');
                    $(this).after(message);
                    $(this).remove();
                });
            }
        }
        
        // Mettre à jour l'aperçu lors du chargement de la page
        updatePreview();
        
        // Mettre à jour l'aperçu lorsque les options changent
        $('input[name="font_size"], input[name="message_alignment"], input[name="bubble_style"], input[name="compact_mode"], input[name="show_avatars"]').change(function() {
            updatePreview();
        });
        
        // Gestion de l'onglet Personnalisation
        $('#accent_color').on('input', function() {
            var color = $(this).val();
            $('.color-preview').css('background-color', color);
            $('.color-value').text(color);
            $('.personalization-preview').css('--accent-color', color);
        });
        
        // Gestion des options d'arrière-plan
        $('input[name="background_style"]').change(function() {
            var style = $(this).val();
            
            // Mettre à jour la sélection visuelle
            $('.background-option').removeClass('selected');
            $(this).closest('.background-option').addClass('selected');
            
            // Afficher/masquer le champ d'URL personnalisée
            if (style === 'custom') {
                $('.custom-background-group').slideDown();
            } else {
                $('.custom-background-group').slideUp();
            }
        });
        
        // Gestion des options d'emoji
        $('input[name="emoji_style"]').change(function() {
            // Mettre à jour la sélection visuelle
            $('.emoji-option').removeClass('selected');
            $(this).closest('.emoji-option').addClass('selected');
        });
        
        // Gestion de l'onglet Automatisation
        $('#auto_reply').change(function() {
            if ($(this).is(':checked')) {
                $('.auto-reply-message').slideDown();
            } else {
                $('.auto-reply-message').slideUp();
            }
        });
        
        $('#message_templates').change(function() {
            if ($(this).is(':checked')) {
                $('.templates-container').slideDown();
            } else {
                $('.templates-container').slideUp();
            }
        });
        
        // Gestion des modèles de messages
        $('.edit-template').click(function() {
            var templateItem = $(this).closest('.template-item');
            var templateName = templateItem.find('.template-name').text();
            var templateText = templateItem.find('.template-text').text();
            
            // Ici, vous pourriez ouvrir une boîte de dialogue pour modifier le modèle
            alert('Modifier le modèle: ' + templateName + '\n\nTexte actuel: ' + templateText);
        });
        
        $('.delete-template').click(function() {
            var templateItem = $(this).closest('.template-item');
            var templateName = templateItem.find('.template-name').text();
            
            // Confirmation avant suppression
            if (confirm('Êtes-vous sûr de vouloir supprimer le modèle "' + templateName + '" ?')) {
                templateItem.fadeOut(300, function() {
                    $(this).remove();
                });
            }
        });
        
        $('.add-template-btn').click(function() {
            // Ici, vous pourriez ouvrir une boîte de dialogue pour ajouter un nouveau modèle
            alert('Ajouter un nouveau modèle de message');
        });
    });
</script>