<?php
// Vérifier si l'utilisateur est connecté directement
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}

// Traitement du formulaire d'affichage
if (isset($_POST['update_view'])) {
    // Mise à jour des paramètres d'affichage
    $font_size = isset($_POST['font_size']) ? $_POST['font_size'] : 'medium';
    $message_alignment = isset($_POST['message_alignment']) ? $_POST['message_alignment'] : 'standard';
    $bubble_style = isset($_POST['bubble_style']) ? $_POST['bubble_style'] : 'rounded';
    $compact_mode = isset($_POST['compact_mode']) ? 1 : 0;
    $show_avatars = isset($_POST['show_avatars']) ? 1 : 0;
    
    // Mettre à jour les paramètres d'affichage (à implémenter dans la classe User)
    // Pour l'instant, nous simulons une mise à jour réussie
    $success_message = "Vos paramètres d'affichage ont été mis à jour avec succès.";
    $active_tab = 'view';
}
?>

<div class="tab-pane <?php echo $active_tab === 'view' ? 'active' : ''; ?>" id="view">
    <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post" class="settings-form">
        <h3>Paramètres d'affichage</h3>
        
        <div class="form-group">
            <label>Taille de police</label>
            <div class="radio-group">
                <label class="radio-option">
                    <input type="radio" name="font_size" value="small" <?php echo ($view_preferences['font_size'] === 'small') ? 'checked' : ''; ?>>
                    Petite
                </label>
                <label class="radio-option">
                    <input type="radio" name="font_size" value="medium" <?php echo ($view_preferences['font_size'] === 'medium') ? 'checked' : ''; ?>>
                    Moyenne
                </label>
                <label class="radio-option">
                    <input type="radio" name="font_size" value="large" <?php echo ($view_preferences['font_size'] === 'large') ? 'checked' : ''; ?>>
                    Grande
                </label>
            </div>
        </div>
        
        <div class="form-group">
            <label>Alignement des messages</label>
            <div class="radio-group">
                <label class="radio-option">
                    <input type="radio" name="message_alignment" value="standard" <?php echo ($view_preferences['message_alignment'] === 'standard') ? 'checked' : ''; ?>>
                    Standard
                </label>
                <label class="radio-option">
                    <input type="radio" name="message_alignment" value="centered" <?php echo ($view_preferences['message_alignment'] === 'centered') ? 'checked' : ''; ?>>
                    Centré
                </label>
                <label class="radio-option">
                    <input type="radio" name="message_alignment" value="right" <?php echo ($view_preferences['message_alignment'] === 'right') ? 'checked' : ''; ?>>
                    Droite
                </label>
            </div>
        </div>
        
        <div class="form-group">
            <label>Style des bulles</label>
            <div class="radio-group">
                <label class="radio-option">
                    <input type="radio" name="bubble_style" value="square" <?php echo ($view_preferences['bubble_style'] === 'square') ? 'checked' : ''; ?>>
                    Carré
                </label>
                <label class="radio-option">
                    <input type="radio" name="bubble_style" value="rounded" <?php echo ($view_preferences['bubble_style'] === 'rounded') ? 'checked' : ''; ?>>
                    Arrondi
                </label>
                <label class="radio-option">
                    <input type="radio" name="bubble_style" value="modern" <?php echo ($view_preferences['bubble_style'] === 'modern') ? 'checked' : ''; ?>>
                    Moderne
                </label>
            </div>
        </div>
        
        <div class="form-group">
            <label class="checkbox-label">
                <input type="checkbox" name="compact_mode" <?php echo ($view_preferences['compact_mode'] == 1) ? 'checked' : ''; ?>>
                Mode compact
            </label>
            <p class="form-text">Réduire l'espacement entre les messages pour en afficher plus à l'écran</p>
        </div>
        
        <div class="form-group">
            <label class="checkbox-label">
                <input type="checkbox" name="show_avatars" <?php echo ($view_preferences['show_avatars'] == 1) ? 'checked' : ''; ?>>
                Afficher les avatars dans les conversations
            </label>
            <p class="form-text">Montrer les photos de profil à côté des messages</p>
        </div>
        
        <div class="preview-container">
            <h4 class="preview-title">Aperçu</h4>
            <div class="message-preview font-medium alignment-standard" id="message-preview">
                <?php if ($view_preferences['show_avatars']): ?>
                <div class="message-with-avatar">
                    <div class="preview-avatar">J</div>
                    <div class="preview-message received bubble-rounded">
                        Bonjour, comment vas-tu aujourd'hui ?
                        <div class="preview-message-time">10:30</div>
                    </div>
                </div>
                <?php else: ?>
                <div class="preview-message received bubble-rounded">
                    Bonjour, comment vas-tu aujourd'hui ?
                    <div class="preview-message-time">10:30</div>
                </div>
                <?php endif; ?>
                
                <div class="preview-message sent bubble-rounded">
                    Très bien merci ! Et toi ?
                    <div class="preview-message-time">10:32</div>
                </div>
                
                <?php if ($view_preferences['show_avatars']): ?>
                <div class="message-with-avatar">
                    <div class="preview-avatar">J</div>
                    <div class="preview-message received bubble-rounded">
                        Parfait ! On se voit plus tard ?
                        <div class="preview-message-time">10:33</div>
                    </div>
                </div>
                <?php else: ?>
                <div class="preview-message received bubble-rounded">
                    Parfait ! On se voit plus tard ?
                    <div class="preview-message-time">10:33</div>
                </div>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="form-group" style="margin-top: 20px;">
            <button type="submit" name="update_view" class="btn btn-primary">
                <i class="fas fa-save"></i> Enregistrer les modifications
            </button>
        </div>
    </form>
</div>